/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateColumn;
import org.jboss.tools.hibernate.jpt.ui.internal.mappings.db.xpl.ColumnCombo;
import org.jboss.tools.hibernate.jpt.ui.internal.mappings.db.xpl.DatabaseObjectCombo;

public class HibernateColumnComposite
extends Pane<HibernateColumn> {
    public HibernateColumnComposite(Pane<?> parentPane, PropertyValueModel<? extends HibernateColumn> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    private ColumnCombo<HibernateColumn> addColumnCombo(Composite container) {
        return new ColumnCombo<HibernateColumn>((Pane)this, container){

            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                this.comboBox.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(((HibernateColumn)this.getSubject()).getName());
                            this.setPopulating(false);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(this.getValue());
                            this.setPopulating(false);
                        }
                    }
                });
            }

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTableName");
            }

            protected void propertyChanged(String propertyName) {
                if (propertyName == "defaultTable" || propertyName == "specifiedTableName") {
                    this.doPopulate();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((HibernateColumn)this.getSubject()).getDefaultDBColumnName();
            }

            protected void setValue(String value) {
                ((HibernateColumn)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((HibernateColumn)this.getSubject()).getDbTable();
            }

            protected String getValue() {
                String specifiedName = ((HibernateColumn)this.getSubject()).getSpecifiedName();
                if (specifiedName == null) {
                    return null;
                }
                String dbColumnName = ((HibernateColumn)this.getSubject()).getDBColumnName();
                if (specifiedName.equals(dbColumnName)) {
                    return specifiedName;
                }
                return String.valueOf(specifiedName) + " (" + dbColumnName + ")";
            }

            public String toString() {
                return "ColumnComposite.columnCombo";
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildColumnDefinitionHolder() {
        return new PropertyAspectAdapter<SpecifiedColumn, String>(this.getSubjectHolder(), new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((SpecifiedColumn)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((SpecifiedColumn)this.subject).setColumnDefinition(value);
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildInsertableHolder() {
        return new PropertyAspectAdapter<SpecifiedColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertable"}){

            protected Boolean buildValue_() {
                return ((SpecifiedColumn)this.subject).getSpecifiedInsertable();
            }

            protected void setValue_(Boolean value) {
                ((SpecifiedColumn)this.subject).setSpecifiedInsertable(value);
            }
        };
    }

    private PropertyValueModel<String> buildInsertableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildInsertableHolder()){

            protected String transform(Boolean value) {
                if (HibernateColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateColumn)HibernateColumnComposite.this.getSubject()).isDefaultInsertable();
                    String defaultStringValue = defaultValue ? JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_TRUE : JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.COLUMN_COMPOSITE_INSERTABLE_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.COLUMN_COMPOSITE_INSERTABLE;
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildNullableHolder() {
        return new PropertyAspectAdapter<SpecifiedColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedNullable"}){

            protected Boolean buildValue_() {
                return ((SpecifiedColumn)this.subject).getSpecifiedNullable();
            }

            protected void setValue_(Boolean value) {
                ((SpecifiedColumn)this.subject).setSpecifiedNullable(value);
            }
        };
    }

    private PropertyValueModel<String> buildNullableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultNullableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_TRUE : JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.COLUMN_COMPOSITE_NULLABLE_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.COLUMN_COMPOSITE_NULLABLE;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultNullableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedNullable", "defaultNullable"}){

            protected Boolean buildValue_() {
                if (((Column)this.subject).getSpecifiedNullable() != null) {
                    return null;
                }
                return ((Column)this.subject).isDefaultNullable();
            }
        };
    }

    private Pane<HibernateColumn> addTableCombo(Composite container) {
        return new DatabaseObjectCombo<HibernateColumn>((Pane)this, container){

            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                this.comboBox.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(((HibernateColumn)this.getSubject()).getName());
                            this.setPopulating(false);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(this.getValue());
                            this.setPopulating(false);
                        }
                    }
                });
            }

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTableName");
            }

            protected String getDefaultValue() {
                return ((HibernateColumn)this.getSubject()).getDefaultDBTableName();
            }

            protected void setValue(String value) {
                ((HibernateColumn)this.getSubject()).setSpecifiedTableName(value);
            }

            protected String getValue() {
                String specifiedName = ((HibernateColumn)this.getSubject()).getSpecifiedTableName();
                if (specifiedName == null) {
                    return null;
                }
                String dbTableName = ((HibernateColumn)this.getSubject()).getDBTableName();
                if (specifiedName.equals(dbTableName)) {
                    return specifiedName;
                }
                return String.valueOf(specifiedName) + " (" + dbTableName + ")";
            }

            @Override
            protected Iterable<String> getValues_() {
                return ((HibernateColumn)this.getSubject()).getCandidateTableNames();
            }

            public String toString() {
                return "ColumnComposite.tableCombo";
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildUniqueHolder() {
        return new PropertyAspectAdapter<SpecifiedColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUnique"}){

            protected Boolean buildValue_() {
                return ((SpecifiedColumn)this.subject).getSpecifiedUnique();
            }

            protected void setValue_(Boolean value) {
                ((SpecifiedColumn)this.subject).setSpecifiedUnique(value);
            }
        };
    }

    private PropertyValueModel<String> buildUniqueStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultUniqueHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_TRUE : JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UNIQUE_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UNIQUE;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultUniqueHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUnique", "defaultUnique"}){

            protected Boolean buildValue_() {
                if (((Column)this.subject).getSpecifiedUnique() != null) {
                    return null;
                }
                return ((Column)this.subject).isDefaultUnique();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildUpdatableHolder() {
        return new PropertyAspectAdapter<SpecifiedColumn, Boolean>(this.getSubjectHolder(), new String[]{"defaultUpdatable", "specifiedUpdatable"}){

            protected Boolean buildValue_() {
                return ((SpecifiedColumn)this.subject).getSpecifiedUpdatable();
            }

            protected void setValue_(Boolean value) {
                ((SpecifiedColumn)this.subject).setSpecifiedUpdatable(value);
            }
        };
    }

    private PropertyValueModel<String> buildUpdatableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultUpdatableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_TRUE : JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UPDATABLE_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UPDATABLE;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultUpdatableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUpdatable", "defaultUpdatable"}){

            protected Boolean buildValue_() {
                if (((Column)this.subject).getSpecifiedUpdatable() != null) {
                    return null;
                }
                return ((Column)this.subject).isDefaultUpdatable();
            }
        };
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_NAME);
        this.addColumnCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_TABLE);
        this.addTableCombo(container);
        final Section detailsSection = this.getWidgetFactory().createSection(container, 2);
        detailsSection.setLayoutData((Object)new GridData(768));
        detailsSection.setText(JptJpaUiDetailsMessages.COLUMN_COMPOSITE_DETAILS);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        detailsSection.setLayoutData((Object)gridData);
        detailsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && detailsSection.getClient() == null) {
                    detailsSection.setClient((Control)HibernateColumnComposite.this.initializeDetailsSection((Composite)detailsSection));
                }
            }
        });
    }

    protected Composite initializeDetailsSection(Composite container) {
        Composite detailsClient = this.addSubPane(container, 2, 0, 16, 0, 0);
        TriStateCheckBox insertableCheckBox = this.addTriStateCheckBoxWithDefault(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_INSERTABLE, this.buildInsertableHolder(), this.buildInsertableStringHolder(), JpaHelpContextIds.MAPPING_COLUMN_INSERTABLE);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        insertableCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox updatableCheckBox = this.addTriStateCheckBoxWithDefault(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UPDATABLE, this.buildUpdatableHolder(), this.buildUpdatableStringHolder(), JpaHelpContextIds.MAPPING_COLUMN_UPDATABLE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        updatableCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox uniqueCheckBox = this.addTriStateCheckBoxWithDefault(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UNIQUE, this.buildUniqueHolder(), this.buildUniqueStringHolder(), JpaHelpContextIds.MAPPING_COLUMN_UNIQUE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        uniqueCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox nullableCheckBox = this.addTriStateCheckBoxWithDefault(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_NULLABLE, this.buildNullableHolder(), this.buildNullableStringHolder(), JpaHelpContextIds.MAPPING_COLUMN_NULLABLE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        nullableCheckBox.getCheckBox().setLayoutData((Object)gridData);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_LENGTH);
        this.addLengthCombo(detailsClient);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_PRECISION);
        this.addPrecisionCombo(detailsClient);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_SCALE);
        this.addScaleCombo(detailsClient);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_COLUMN_DEFINITION);
        this.addText(detailsClient, this.buildColumnDefinitionHolder());
        return detailsClient;
    }

    private void addLengthCombo(Composite container) {
        new IntegerCombo<HibernateColumn>((Pane)this, container){

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN_LENGTH;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<HibernateColumn, Integer>(this.getSubjectHolder(), new String[]{"defaultLength"}){

                    protected Integer buildValue_() {
                        return ((HibernateColumn)this.subject).getDefaultLength();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<HibernateColumn, Integer>(this.getSubjectHolder(), new String[]{"specifiedLength"}){

                    protected Integer buildValue_() {
                        return ((HibernateColumn)this.subject).getSpecifiedLength();
                    }

                    protected void setValue_(Integer value) {
                        ((HibernateColumn)this.subject).setSpecifiedLength(value);
                    }
                };
            }
        };
    }

    private void addPrecisionCombo(Composite container) {
        new IntegerCombo<HibernateColumn>((Pane)this, container){

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN_PRECISION;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<HibernateColumn, Integer>(this.getSubjectHolder(), new String[]{"defaultPrecision"}){

                    protected Integer buildValue_() {
                        return ((HibernateColumn)this.subject).getDefaultPrecision();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<SpecifiedColumn, Integer>(this.getSubjectHolder(), new String[]{"specifiedPrecision"}){

                    protected Integer buildValue_() {
                        return ((SpecifiedColumn)this.subject).getSpecifiedPrecision();
                    }

                    protected void setValue_(Integer value) {
                        ((SpecifiedColumn)this.subject).setSpecifiedPrecision(value);
                    }
                };
            }
        };
    }

    private void addScaleCombo(Composite container) {
        new IntegerCombo<HibernateColumn>((Pane)this, container){

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN_SCALE;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<HibernateColumn, Integer>(this.getSubjectHolder(), new String[]{"defaultScale"}){

                    protected Integer buildValue_() {
                        return ((HibernateColumn)this.subject).getDefaultScale();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<SpecifiedColumn, Integer>(this.getSubjectHolder(), new String[]{"specifiedScale"}){

                    protected Integer buildValue_() {
                        return ((SpecifiedColumn)this.subject).getSpecifiedScale();
                    }

                    protected void setValue_(Integer value) {
                        ((SpecifiedColumn)this.subject).setSpecifiedScale(value);
                    }
                };
            }
        };
    }
}

