/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SingletonItem;
import net.sf.saxon.value.Whitespace;

public abstract class Value
implements Serializable,
SequenceIterable,
ValueRepresentation {
    private static double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8};
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;

    public static Value asValue(ValueRepresentation val) {
        if (val instanceof Value) {
            return (Value)val;
        }
        if (val == null) {
            return EmptySequence.getInstance();
        }
        return new SingletonItem((Item)val);
    }

    public static Item asItem(ValueRepresentation value) throws XPathException {
        if (value instanceof Item) {
            return (Item)value;
        }
        return ((Value)value).asItem();
    }

    public Item asItem() throws XPathException {
        SequenceIterator iter = this.iterate();
        Item item = iter.next();
        if (item == null) {
            return null;
        }
        if (iter.next() != null) {
            throw new XPathException("Attempting to access a sequence as a singleton item");
        }
        return item;
    }

    public static Value fromItem(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        if (item instanceof AtomicValue) {
            return (AtomicValue)item;
        }
        return new SingletonItem(item);
    }

    public static SequenceIterator asIterator(ValueRepresentation val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).iterate();
        }
        if (val == null) {
            return EmptyIterator.getInstance();
        }
        return SingletonIterator.makeIterator((Item)val);
    }

    public static double stringToNumber(CharSequence s) throws NumberFormatException {
        String n;
        int len = s.length();
        boolean containsDisallowedChars = false;
        boolean containsWhitespace = false;
        if (len < 9) {
            boolean useJava = false;
            long num = 0L;
            int dot = -1;
            int lastDigit = -1;
            boolean onlySpaceAllowed = false;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        containsWhitespace = true;
                        if (lastDigit == -1) break;
                        onlySpaceAllowed = true;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (onlySpaceAllowed) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        lastDigit = i;
                        num = num * 10L + (long)(c - 48);
                        break;
                    }
                    case '.': {
                        if (onlySpaceAllowed) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        if (dot != -1) {
                            throw new NumberFormatException("Only one decimal point allowed");
                        }
                        dot = i;
                        break;
                    }
                    case 'D': 
                    case 'F': 
                    case 'N': 
                    case 'X': 
                    case 'd': 
                    case 'f': 
                    case 'n': 
                    case 'x': {
                        containsDisallowedChars = true;
                        useJava = true;
                        break;
                    }
                    default: {
                        useJava = true;
                    }
                }
                ++i;
            }
            if (!useJava) {
                if (lastDigit == -1) {
                    throw new NumberFormatException("No digits found");
                }
                if (dot == -1 || dot > lastDigit) {
                    return num;
                }
                int afterPoint = lastDigit - dot;
                return (double)num / powers[afterPoint];
            }
        } else {
            int i = 0;
            block11: while (i < s.length()) {
                char c = s.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        containsWhitespace = true;
                        break;
                    }
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'E': 
                    case 'e': {
                        break;
                    }
                    default: {
                        containsDisallowedChars = true;
                        break block11;
                    }
                }
                ++i;
            }
        }
        String string = n = containsWhitespace ? Whitespace.trimWhitespace(s).toString() : s.toString();
        if ("INF".equals(n)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("+INF".equals(n)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(n)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(n)) {
            return Double.NaN;
        }
        if (containsDisallowedChars) {
            throw new NumberFormatException("invalid floating point value: " + s);
        }
        return Double.parseDouble(n);
    }

    public static SequenceIterator getIterator(ValueRepresentation val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).iterate();
        }
        if (val instanceof Item) {
            return SingletonIterator.makeIterator((Item)val);
        }
        if (val == null) {
            throw new AssertionError((Object)"Value of variable is undefined (null)");
        }
        throw new AssertionError((Object)("Unknown value representation " + val.getClass()));
    }

    public abstract SequenceIterator iterate() throws XPathException;

    @Override
    public final SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.iterate();
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return this.getStringValue();
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        try {
            return this.getStringValueCS();
        }
        catch (XPathException err) {
            throw new IllegalStateException("Failed to get canonical lexical representation: " + err.getMessage());
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        SequenceIterator iter;
        block4: {
            try {
                iter = this.iterate();
                Item next = iter.next();
                if (next != null) break block4;
                return 8192;
            }
            catch (XPathException xPathException) {
                return 57344;
            }
        }
        if (iter.next() != null) {
            return 49152;
        }
        return 16384;
    }

    public Item itemAt(int n) throws XPathException {
        Item item;
        if (n < 0) {
            return null;
        }
        int i = 0;
        SequenceIterator iter = this.iterate();
        do {
            if ((item = iter.next()) != null) continue;
            return null;
        } while (i++ != n);
        return item;
    }

    public int getLength() throws XPathException {
        return Aggregate.count(this.iterate());
    }

    public void process(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator iter = this.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter.next()) != null) {
            out.append(it, 0, 2);
        }
    }

    @Override
    public String getStringValue() throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(64);
        SequenceIterator iter = this.iterate();
        Item item = iter.next();
        if (item != null) {
            while (true) {
                sb.append(item.getStringValueCS());
                item = iter.next();
                if (item == null) break;
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    public Comparable getSchemaComparable() {
        return new ValueSchemaComparable();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("Value.equals()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isIdentical(Value v) {
        try {
            Item m1;
            Item m0;
            boolean n1;
            boolean n0;
            SequenceIterator i0 = this.iterate();
            SequenceIterator i1 = v.iterate();
            do {
                m0 = i0.next();
                m1 = i1.next();
                if (m0 == null && m1 == null) {
                    return true;
                }
                if (m0 == null || m1 == null) {
                    return false;
                }
                n0 = m0 instanceof NodeInfo;
                n1 = m1 instanceof NodeInfo;
                if (n0 != n1) {
                    return false;
                }
                if (!n0 || !n1 || ((NodeInfo)m0).isSameNodeInfo((NodeInfo)m1)) continue;
                return false;
            } while (n0 || n1 || ((AtomicValue)m0).isIdentical((AtomicValue)m1));
            return false;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
    }

    public Value reduce() throws XPathException {
        return this;
    }

    public static Object convertToJava(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object node = item;
            while (node instanceof VirtualNode) {
                node = ((VirtualNode)node).getRealNode();
            }
            return node;
        }
        if (item instanceof FunctionItem) {
            return item;
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getObject();
        }
        AtomicValue value = (AtomicValue)item;
        switch (value.getItemType(null).getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 631: {
                return value.getStringValue();
            }
            case 514: {
                return ((BooleanValue)value).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((DecimalValue)value).getDecimalValue();
            }
            case 532: {
                return new Long(((NumericValue)value).longValue());
            }
            case 517: {
                return new Double(((DoubleValue)value).getDoubleValue());
            }
            case 516: {
                return new Float(((FloatValue)value).getFloatValue());
            }
            case 519: {
                return ((DateTimeValue)value).getCalendar().getTime();
            }
            case 521: {
                return ((DateValue)value).getCalendar().getTime();
            }
            case 520: {
                return value.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)value).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)value).getBinaryValue();
            }
        }
        return item;
    }

    private class ValueSchemaComparable
    implements Comparable {
        private ValueSchemaComparable() {
        }

        public Value getValue() {
            return Value.this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int compareTo(Object obj) {
            try {
                Item item2;
                Item item1;
                int c;
                if (!(obj instanceof ValueSchemaComparable)) {
                    return Integer.MIN_VALUE;
                }
                SequenceIterator iter1 = this.getValue().iterate();
                SequenceIterator iter2 = ((ValueSchemaComparable)obj).getValue().iterate();
                do {
                    item1 = iter1.next();
                    item2 = iter2.next();
                    if (item1 == null && item2 == null) {
                        return 0;
                    }
                    if (item1 == null) {
                        return -1;
                    }
                    if (item2 == null) {
                        return 1;
                    }
                    if (item1 instanceof AtomicValue && item2 instanceof AtomicValue) continue;
                    throw new UnsupportedOperationException("Sequences containing nodes or function items are not schema-comparable");
                } while ((c = ((AtomicValue)item1).getSchemaComparable().compareTo(((AtomicValue)item2).getSchemaComparable())) == 0);
                return c;
            }
            catch (XPathException e) {
                throw new AssertionError((Object)("Failure comparing schema values: " + e.getMessage()));
            }
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            try {
                int hash = 107189858;
                SequenceIterator iter = this.getValue().iterate();
                while (true) {
                    Item item;
                    if ((item = iter.next()) == null) {
                        return hash;
                    }
                    hash ^= ((AtomicValue)item).getSchemaComparable().hashCode();
                }
            }
            catch (XPathException xPathException) {
                return 0;
            }
        }
    }
}

