/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Pattern;
import net.sf.saxon.charcode.UTF16CharacterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    public static final StringValue SINGLE_SPACE = new StringValue(" ");
    public static final StringValue TRUE = new StringValue("true");
    public static final StringValue FALSE = new StringValue("false");
    protected CharSequence value;
    protected boolean noSurrogates = false;

    protected StringValue() {
        this.value = "";
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence value) {
        this.value = value == null ? "" : value;
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public void setContainsNoSurrogates() {
        this.noSurrogates = true;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        StringValue v = new StringValue(this.value);
        v.noSurrogates = this.noSurrogates;
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.STRING;
    }

    public static StringValue makeStringValue(CharSequence value) {
        if (value == null || value.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(value);
    }

    @Override
    public final String getPrimitiveStringValue() {
        this.value = this.value.toString();
        return this.value;
    }

    public final void setStringValueCS(CharSequence value) {
        this.value = value;
    }

    @Override
    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        int req = requiredType.getFingerprint();
        if (req == 513 || req == 632) {
            return this;
        }
        return StringValue.convertStringToBuiltInType(this.value, requiredType, validate ? context.getConfiguration().getNameChecker() : null);
    }

    public static ConversionResult convertStringToBuiltInType(CharSequence value, BuiltInAtomicType requiredType, NameChecker checker) {
        try {
            switch (requiredType.getFingerprint()) {
                case 514: {
                    return BooleanValue.fromString(value);
                }
                case 517: 
                case 635: {
                    return new DoubleValue(value);
                }
                case 532: {
                    return Int64Value.stringToInteger(value);
                }
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: {
                    ConversionResult iv = IntegerValue.stringToInteger(value);
                    if (iv instanceof ValidationFailure) {
                        return iv;
                    }
                    IntegerValue nv = (IntegerValue)((IntegerValue)iv).copyAsSubType(requiredType);
                    ValidationFailure err = nv.convertToSubType(requiredType, checker != null);
                    return err == null ? nv : err;
                }
                case 515: {
                    return DecimalValue.makeDecimalValue(value, checker != null);
                }
                case 516: {
                    return new FloatValue(value);
                }
                case 521: {
                    return DateValue.makeDateValue(value);
                }
                case 519: {
                    return DateTimeValue.makeDateTimeValue(value);
                }
                case 565: {
                    ValidationFailure vf;
                    ConversionResult cr = DateTimeValue.makeDateTimeValue(value);
                    if (cr instanceof DateTimeValue && (vf = ((DateTimeValue)cr).convertToSubType(requiredType)) != null) {
                        cr = vf;
                    }
                    return cr;
                }
                case 520: {
                    return TimeValue.makeTimeValue(value);
                }
                case 523: {
                    return GYearValue.makeGYearValue(value);
                }
                case 522: {
                    return GYearMonthValue.makeGYearMonthValue(value);
                }
                case 526: {
                    return GMonthValue.makeGMonthValue(value);
                }
                case 524: {
                    return GMonthDayValue.makeGMonthDayValue(value);
                }
                case 525: {
                    return GDayValue.makeGDayValue(value);
                }
                case 518: {
                    return DurationValue.makeDuration(value);
                }
                case 633: {
                    return YearMonthDurationValue.makeYearMonthDurationValue(value);
                }
                case 634: {
                    return DayTimeDurationValue.makeDayTimeDurationValue(value);
                }
                case 573: 
                case 631: {
                    return new UntypedAtomicValue(value);
                }
                case 513: 
                case 632: {
                    return StringValue.makeStringValue(value);
                }
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 563: {
                    return StringValue.makeRestrictedString(value, requiredType, checker);
                }
                case 529: {
                    if (AnyURIValue.isValidURI(value)) {
                        return new AnyURIValue(value);
                    }
                    ValidationFailure ve = new ValidationFailure("Invalid URI: " + value.toString());
                    ve.setErrorCode("FORG0001");
                    return ve;
                }
                case 527: {
                    return new HexBinaryValue(value);
                }
                case 528: {
                    return new Base64BinaryValue(value);
                }
            }
            ValidationFailure ve = new ValidationFailure("Cannot convert string to type " + Err.wrap(requiredType.getDisplayName()));
            ve.setErrorCode("XPTY0004");
            return ve;
        }
        catch (ValidationException err) {
            ValidationFailure vf = new ValidationFailure(err.getMessage());
            vf.setErrorCodeQName(err.getErrorCodeQName());
            if (vf.getErrorCodeQName() == null) {
                vf.setErrorCode("FORG0001");
            }
            return vf;
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("FORG0001");
            ValidationFailure ve = new ValidationFailure(err.getMessage());
            if (err.getErrorCodeQName() == null) {
                ve.setErrorCode("FORG0001");
            } else {
                ve.setErrorCodeQName(err.getErrorCodeQName());
            }
            return ve;
        }
    }

    public static ConversionResult convertStringToAtomicType(CharSequence value, AtomicType targetType, NameChecker checker) {
        if (targetType instanceof BuiltInAtomicType) {
            return StringValue.convertStringToBuiltInType(value, (BuiltInAtomicType)targetType, checker);
        }
        BuiltInAtomicType primitiveType = (BuiltInAtomicType)targetType.getPrimitiveItemType();
        if (primitiveType.getFingerprint() == 513) {
            int whitespaceAction = targetType.getWhitespaceAction(null);
            value = Whitespace.applyWhitespaceNormalization(whitespaceAction, value);
        }
        try {
            value = targetType.preprocess(value);
        }
        catch (ValidationException err) {
            return new ValidationFailure(err);
        }
        ConversionResult result = StringValue.convertStringToBuiltInType(value, primitiveType, checker);
        if (result instanceof ValidationFailure) {
            return result;
        }
        ValidationFailure vf = targetType.validate((AtomicValue)result, value, checker);
        if (vf != null) {
            return vf;
        }
        return ((AtomicValue)result).copyAsSubType(targetType);
    }

    public int getStringLength() {
        if (this.noSurrogates) {
            return this.value.length();
        }
        int len = StringValue.getStringLength(this.value);
        if (len == this.value.length()) {
            this.noSurrogates = true;
        }
        return len;
    }

    public static int getStringLength(CharSequence s) {
        int n = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < '\ud800' || c > '\udbff') {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public boolean isZeroLength() {
        return this.value.length() == 0;
    }

    public boolean containsSurrogatePairs() {
        return this.noSurrogates ? false : this.getStringLength() != this.value.length();
    }

    public boolean isKnownToContainNoSurrogates() {
        return this.noSurrogates;
    }

    public UnfailingIterator iterateCharacters() {
        return new CharacterIterator();
    }

    public int[] expand() {
        int[] array = new int[this.getStringLength()];
        int o = 0;
        int len = this.value.length();
        int i = 0;
        while (i < len) {
            int charval;
            int c = this.value.charAt(i);
            if (c >= 55296 && c <= 56319) {
                charval = (c - 55296) * 1024 + (this.value.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c;
            }
            array[o++] = charval;
            ++i;
        }
        return array;
    }

    public static int[] expand(CharSequence s) {
        int[] array = new int[StringValue.getStringLength(s)];
        int o = 0;
        int i = 0;
        while (i < s.length()) {
            int charval;
            int c = s.charAt(i);
            if (c >= 55296 && c <= 56319) {
                charval = (c - 55296) * 1024 + (s.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c;
            }
            array[o++] = charval;
            ++i;
        }
        return array;
    }

    public static CharSequence contract(int[] codes, int used) {
        FastStringBuffer sb = new FastStringBuffer(codes.length);
        int i = 0;
        while (i < used) {
            if (codes[i] < 65536) {
                sb.append((char)codes[i]);
            } else {
                sb.append(UTF16CharacterSet.highSurrogate(codes[i]));
                sb.append(UTF16CharacterSet.lowSurrogate(codes[i]));
            }
            ++i;
        }
        return sb;
    }

    @Override
    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return collator.getCollationKey(this.value.toString());
    }

    @Override
    public boolean equals(Object other) {
        throw new ClassCastException("equals on StringValue is not allowed");
    }

    public boolean codepointEquals(StringValue other) {
        return this.value.length() == other.value.length() && this.value.toString().equals(other.value.toString());
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.value.length() > 0;
    }

    @Override
    public String toString() {
        return "\"" + this.value + '\"';
    }

    public static ConversionResult makeRestrictedString(CharSequence value, BuiltInAtomicType typeLabel, NameChecker checker) {
        StringValue rsv = new StringValue();
        int type = typeLabel.getFingerprint();
        rsv.setTypeLabel(typeLabel);
        if (value == null) {
            rsv.value = "";
        } else if (type == 553) {
            rsv.value = Whitespace.normalizeWhitespace(value);
        } else if (type == 554) {
            rsv.value = Whitespace.collapseWhitespace(value);
        } else {
            rsv.value = Whitespace.trimWhitespace(value);
            if (checker != null) {
                ValidationFailure err = StringValue.validate(typeLabel, rsv.value, checker);
                if (err == null) {
                    return rsv;
                }
                return err;
            }
            return rsv;
        }
        return rsv;
    }

    public static ValidationFailure validate(BuiltInAtomicType typeLabel, CharSequence val, NameChecker checker) {
        switch (typeLabel.getFingerprint()) {
            case 554: {
                return null;
            }
            case 553: {
                return null;
            }
            case 555: {
                String regex = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
                if (!Pattern.matches(regex, val.toString())) {
                    ValidationFailure err = new ValidationFailure("The value '" + val + "' is not a valid xs:language");
                    err.setErrorCode("FORG0001");
                    return err;
                }
                return null;
            }
            case 558: {
                FastStringBuffer buff = new FastStringBuffer(val.length());
                buff.append(val);
                int i = 0;
                while (i < buff.length()) {
                    if (buff.charAt(i) == ':') {
                        buff.setCharAt(i, '_');
                    }
                    ++i;
                }
                if (!checker.isValidNCName(buff)) {
                    ValidationFailure err = new ValidationFailure("The value '" + val + "' is not a valid Name");
                    err.setErrorCode("FORG0001");
                    return err;
                }
                return null;
            }
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                if (!checker.isValidNCName(val)) {
                    ValidationFailure err = new ValidationFailure("The value '" + val + "' is not a valid NCName");
                    err.setErrorCode("FORG0001");
                    return err;
                }
                return null;
            }
            case 556: {
                if (!checker.isValidNmtoken(val)) {
                    ValidationFailure err = new ValidationFailure("The value '" + val + "' is not a valid NMTOKEN");
                    err.setErrorCode("FORG0001");
                    return err;
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown string value type " + typeLabel.getFingerprint());
    }

    @Override
    public Comparable getSchemaComparable() {
        return this.value.toString();
    }

    @Override
    public boolean isIdentical(Value v) {
        return v instanceof StringValue && this instanceof AnyURIValue == v instanceof AnyURIValue && this instanceof UntypedAtomicValue == v instanceof UntypedAtomicValue && this.toString().equals(v.toString());
    }

    public static String diagnosticDisplay(String s) {
        FastStringBuffer fsb = new FastStringBuffer(s.length());
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~') {
                fsb.append(c);
            } else {
                fsb.append("\\u");
                int shift = 12;
                while (shift >= 0) {
                    fsb.append("0123456789ABCDEF".charAt(c >> shift & 0xF));
                    shift -= 4;
                }
            }
            ++i;
        }
        return fsb.toString();
    }

    public final class CharacterIterator
    implements UnfailingIterator {
        int inpos = 0;
        int outpos = 0;
        int current = -1;

        @Override
        public Item next() {
            if (this.inpos < StringValue.this.value.length()) {
                char c;
                this.current = (c = StringValue.this.value.charAt(this.inpos++)) >= '\ud800' && c <= '\udbff' ? (c - 55296) * 1024 + (StringValue.this.value.charAt(this.inpos++) - 56320) + 65536 : (int)c;
                ++this.outpos;
                return new Int64Value(this.current);
            }
            this.outpos = -1;
            return null;
        }

        @Override
        public Item current() {
            if (this.outpos < 1) {
                return null;
            }
            return new Int64Value(this.current);
        }

        @Override
        public int position() {
            return this.outpos;
        }

        @Override
        public void close() {
        }

        @Override
        public SequenceIterator getAnother() {
            return new CharacterIterator();
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

