/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.Value;

public abstract class QualifiedNameValue
extends AtomicValue {
    protected StructuredQName qName;

    public static AtomicValue makeQName(String prefix, String uri, String local, AtomicType targetType, CharSequence lexicalForm, Configuration config) throws XPathException {
        if (targetType.getFingerprint() == 530) {
            return new QNameValue(prefix, uri, local, BuiltInAtomicType.QNAME, null);
        }
        QualifiedNameValue qnv = config.getTypeHierarchy().isSubType(targetType, BuiltInAtomicType.QNAME) ? new QNameValue(prefix, uri, local, targetType, null) : new NotationValue(prefix, uri, local, null);
        ValidationFailure vf = targetType.validate(qnv, lexicalForm, config.getNameChecker());
        if (vf != null) {
            throw vf.makeException();
        }
        qnv.setTypeLabel(targetType);
        return qnv;
    }

    @Override
    public final String getPrimitiveStringValue() {
        return this.qName.getDisplayName();
    }

    public StructuredQName toStructuredQName() {
        return this.qName;
    }

    public final String getClarkName() {
        return this.qName.getClarkName();
    }

    public final String getLocalName() {
        return this.qName.getLocalName();
    }

    public final String getNamespaceURI() {
        return this.qName.getNamespaceURI();
    }

    public final String getPrefix() {
        return this.qName.getPrefix();
    }

    public int allocateNameCode(NamePool pool) {
        return pool.allocate(this.getPrefix(), this.getNamespaceURI(), this.getLocalName());
    }

    @Override
    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return ordered ? null : this;
    }

    public int hashCode() {
        return this.qName.hashCode();
    }

    @Override
    public boolean isIdentical(Value v) {
        return super.isIdentical(v) && this.qName.getPrefix().equals(((QualifiedNameValue)v).getPrefix());
    }

    @Override
    public String toString() {
        return "QName(\"" + this.getNamespaceURI() + "\", \"" + this.getLocalName() + "\")";
    }

    public QName toJaxpQName() {
        return this.qName.toJaxpQName();
    }
}

