/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigInteger;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public abstract class IntegerValue
extends NumericValue {
    public static final Int64Value MINUS_ONE = new Int64Value(-1L);
    public static final Int64Value ZERO = new Int64Value(0L);
    public static final Int64Value PLUS_ONE = new Int64Value(1L);
    public static final Int64Value[] SMALL_INTEGERS = new Int64Value[]{ZERO, PLUS_ONE, new Int64Value(2L), new Int64Value(3L), new Int64Value(4L), new Int64Value(5L), new Int64Value(6L), new Int64Value(7L), new Int64Value(8L), new Int64Value(9L), new Int64Value(10L), new Int64Value(11L), new Int64Value(12L), new Int64Value(13L), new Int64Value(14L), new Int64Value(15L), new Int64Value(16L), new Int64Value(17L), new Int64Value(18L), new Int64Value(19L), new Int64Value(20L)};
    public static final Int64Value MAX_LONG = new Int64Value(Long.MAX_VALUE);
    public static final Int64Value MIN_LONG = new Int64Value(Long.MIN_VALUE);
    private static long NO_LIMIT = -9999L;
    private static long MAX_UNSIGNED_LONG = -9998L;
    private static long[] ranges;

    static {
        long[] lArray = new long[39];
        lArray[0] = 532L;
        lArray[1] = NO_LIMIT;
        lArray[2] = NO_LIMIT;
        lArray[3] = 535L;
        lArray[4] = Long.MIN_VALUE;
        lArray[5] = Long.MAX_VALUE;
        lArray[6] = 536L;
        lArray[7] = Integer.MIN_VALUE;
        lArray[8] = Integer.MAX_VALUE;
        lArray[9] = 537L;
        lArray[10] = -32768L;
        lArray[11] = 32767L;
        lArray[12] = 538L;
        lArray[13] = -128L;
        lArray[14] = 127L;
        lArray[15] = 539L;
        lArray[17] = NO_LIMIT;
        lArray[18] = 540L;
        lArray[19] = 1L;
        lArray[20] = NO_LIMIT;
        lArray[21] = 533L;
        lArray[22] = NO_LIMIT;
        lArray[24] = 534L;
        lArray[25] = NO_LIMIT;
        lArray[26] = -1L;
        lArray[27] = 541L;
        lArray[29] = MAX_UNSIGNED_LONG;
        lArray[30] = 542L;
        lArray[32] = 0xFFFFFFFFL;
        lArray[33] = 543L;
        lArray[35] = 65535L;
        lArray[36] = 544L;
        lArray[38] = 255L;
        ranges = lArray;
    }

    public static IntegerValue makeIntegerValue(BigInteger value) {
        if (value.compareTo(BigIntegerValue.MAX_LONG) > 0 || value.compareTo(BigIntegerValue.MIN_LONG) < 0) {
            return new BigIntegerValue(value);
        }
        return Int64Value.makeIntegerValue(value.longValue());
    }

    public abstract ValidationFailure convertToSubType(BuiltInAtomicType var1, boolean var2);

    public abstract ValidationFailure validateAgainstSubType(BuiltInAtomicType var1);

    public static boolean checkRange(long value, BuiltInAtomicType type) {
        int fp = type.getFingerprint();
        int i = 0;
        while (i < ranges.length) {
            if (ranges[i] == (long)fp) {
                long min = ranges[i + 1];
                if (min != NO_LIMIT && value < min) {
                    return false;
                }
                long max = ranges[i + 2];
                return max == NO_LIMIT || max == MAX_UNSIGNED_LONG || value <= max;
            }
            i += 3;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + type.getDescription());
    }

    public static boolean checkBigRange(BigInteger big, BuiltInAtomicType type) {
        int i = 0;
        while (i < ranges.length) {
            if (ranges[i] == (long)type.getFingerprint()) {
                long min = ranges[i + 1];
                if (min != NO_LIMIT && BigInteger.valueOf(min).compareTo(big) > 0) {
                    return false;
                }
                long max = ranges[i + 2];
                if (max == NO_LIMIT) {
                    return true;
                }
                if (max == MAX_UNSIGNED_LONG) {
                    return BigIntegerValue.MAX_UNSIGNED_LONG.compareTo(big) >= 0;
                }
                return BigInteger.valueOf(max).compareTo(big) >= 0;
            }
            i += 3;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + type.getDescription());
    }

    /*
     * Unable to fully structure code
     */
    public static ConversionResult stringToInteger(CharSequence s) {
        block12: {
            len = s.length();
            start = 0;
            last = len - 1;
            while (start < len && s.charAt(start) <= ' ') {
                ++start;
            }
            while (last > start && s.charAt(last) <= ' ') {
                --last;
            }
            if (start > last) {
                return IntegerValue.numericError("Cannot convert zero-length string to an integer");
            }
            if (last - start >= 16) break block12;
            negative = false;
            value = 0L;
            i = start;
            if (s.charAt(i) == '+') {
                ++i;
            } else if (s.charAt(i) == '-') {
                negative = true;
                ++i;
            }
            if (i <= last) ** GOTO lbl28
            return IntegerValue.numericError("Cannot convert string " + Err.wrap(s, 4) + " to integer: no digits after the sign");
lbl-1000:
            // 1 sources

            {
                if ((d = s.charAt(i++)) >= '0' && d <= '9') {
                    value = 10L * value + (long)(d - 48);
                    continue;
                }
                return IntegerValue.numericError("Cannot convert string " + Err.wrap(s, 4) + " to an integer");
lbl28:
                // 2 sources

                ** while (i <= last)
            }
lbl29:
            // 1 sources

            return Int64Value.makeIntegerValue(negative != false ? -value : value);
        }
        try {
            t = Whitespace.trimWhitespace(s);
            if (t.charAt(0) == '+') {
                t = t.subSequence(1, t.length());
            }
            if (t.length() < 16) {
                return new Int64Value(Long.parseLong(t.toString()));
            }
            return new BigIntegerValue(new BigInteger(t.toString()));
        }
        catch (NumberFormatException v0) {
            return IntegerValue.numericError("Cannot convert string " + Err.wrap(s, 4) + " to an integer");
        }
    }

    private static ValidationFailure numericError(String message) {
        ValidationFailure err = new ValidationFailure(message);
        err.setErrorCode("FORG0001");
        return err;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.INTEGER;
    }

    @Override
    public boolean isWholeNumber() {
        return true;
    }

    public abstract IntegerValue plus(IntegerValue var1);

    public abstract IntegerValue minus(IntegerValue var1);

    public abstract IntegerValue times(IntegerValue var1);

    public abstract NumericValue div(IntegerValue var1) throws XPathException;

    public abstract IntegerValue mod(IntegerValue var1) throws XPathException;

    public abstract IntegerValue idiv(IntegerValue var1) throws XPathException;

    public abstract BigInteger asBigInteger();

    protected static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    @Override
    public boolean isIdentical(Value v) {
        return v instanceof IntegerValue && this.equals(v);
    }
}

