/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.NumberInstruction;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.number.NumberFormatter;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLNumber
extends StyleElement {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression select = null;
    private Expression value = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression lang = null;
    private Expression ordinal = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected ItemType getReturnedItemType() {
        return NodeKindTest.TEXT;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String valueAtt = null;
        String countAtt = null;
        String fromAtt = null;
        String levelAtt = null;
        String formatAtt = null;
        String gsizeAtt = null;
        String gsepAtt = null;
        String langAtt = null;
        String letterValueAtt = null;
        String ordinalAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
            } else if (f.equals("value")) {
                valueAtt = atts.getValue(a);
            } else if (f.equals("count")) {
                countAtt = atts.getValue(a);
            } else if (f.equals("from")) {
                fromAtt = atts.getValue(a);
            } else if (f.equals("level")) {
                levelAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("format")) {
                formatAtt = atts.getValue(a);
            } else if (f.equals("lang")) {
                langAtt = atts.getValue(a);
            } else if (f.equals("letter-value")) {
                letterValueAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("grouping-size")) {
                gsizeAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("grouping-separator")) {
                gsepAtt = atts.getValue(a);
            } else if (f.equals("ordinal")) {
                ordinalAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        if (valueAtt != null) {
            this.value = this.makeExpression(valueAtt);
            if (selectAtt != null) {
                this.compileError("The select attribute and value attribute must not both be present", "XTSE0975");
            }
            if (countAtt != null) {
                this.compileError("The count attribute and value attribute must not both be present", "XTSE0975");
            }
            if (fromAtt != null) {
                this.compileError("The from attribute and value attribute must not both be present", "XTSE0975");
            }
            if (levelAtt != null) {
                this.compileError("The level attribute and value attribute must not both be present", "XTSE0975");
            }
        }
        if (countAtt != null) {
            this.count = this.makePattern(countAtt);
            if (countAtt.indexOf(36) >= 0) {
                this.hasVariablesInPatterns = true;
            }
        }
        if (fromAtt != null) {
            this.from = this.makePattern(fromAtt);
            if (fromAtt.indexOf(36) >= 0) {
                this.hasVariablesInPatterns = true;
            }
        }
        if (levelAtt == null) {
            this.level = 0;
        } else if (levelAtt.equals("single")) {
            this.level = 0;
        } else if (levelAtt.equals("multiple")) {
            this.level = 1;
        } else if (levelAtt.equals("any")) {
            this.level = 2;
        } else {
            this.compileError("Invalid value for level attribute", "XTSE0020");
        }
        if (this.level == 0 && this.from == null && this.count == null) {
            this.level = 3;
        }
        if (formatAtt != null) {
            this.format = this.makeAttributeValueTemplate(formatAtt);
            if (this.format instanceof StringLiteral) {
                this.formatter = new NumberFormatter();
                this.formatter.prepare(((StringLiteral)this.format).getStringValue());
            }
        } else {
            this.formatter = new NumberFormatter();
            this.formatter.prepare("1");
        }
        if (gsepAtt != null && gsizeAtt != null) {
            this.groupSize = this.makeAttributeValueTemplate(gsizeAtt);
            this.groupSeparator = this.makeAttributeValueTemplate(gsepAtt);
        }
        if (langAtt == null) {
            this.numberer = this.getConfiguration().makeNumberer(null, null);
        } else {
            this.lang = this.makeAttributeValueTemplate(langAtt);
            if (this.lang instanceof StringLiteral) {
                String language = ((StringLiteral)this.lang).getStringValue();
                this.numberer = this.getConfiguration().makeNumberer(language, null);
            }
        }
        if (letterValueAtt != null) {
            this.letterValue = this.makeAttributeValueTemplate(letterValueAtt);
        }
        if (ordinalAtt != null) {
            this.ordinal = this.makeAttributeValueTemplate(ordinalAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
        this.value = this.typeCheck("value", this.value);
        this.format = this.typeCheck("format", this.format);
        this.groupSize = this.typeCheck("group-size", this.groupSize);
        this.groupSeparator = this.typeCheck("group-separator", this.groupSeparator);
        this.letterValue = this.typeCheck("letter-value", this.letterValue);
        this.ordinal = this.typeCheck("ordinal", this.ordinal);
        this.lang = this.typeCheck("lang", this.lang);
        this.from = this.typeCheck("from", this.from);
        this.count = this.typeCheck("count", this.count);
        if (this.select != null) {
            try {
                RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:number/select"), 0);
                role.setErrorCode("XTTE1000");
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_NODE, false, role, this.makeExpressionVisitor());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        NumberInstruction expr = new NumberInstruction(exec.getConfiguration(), this.select, this.level, this.count, this.from, this.value, this.format, this.groupSize, this.groupSeparator, this.letterValue, this.ordinal, this.lang, this.formatter, this.numberer, this.hasVariablesInPatterns, this.backwardsCompatibleModeIsEnabled());
        int loc = this.getStaticContext().getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber());
        expr.setLocationId(loc);
        ValueOf inst = new ValueOf(expr, false, false);
        inst.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        inst.setIsNumberingInstruction();
        return inst;
    }
}

