/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.sort.Sortable;

public class GenericSorter {
    private static final int SMALL = 7;
    private static final int MEDIUM = 7;
    private static final int LARGE = 40;

    protected GenericSorter() {
    }

    public static void quickSort(int fromIndex, int toIndex, Sortable c) {
        GenericSorter.quickSort1(fromIndex, toIndex - fromIndex, c);
    }

    private static void quickSort1(int off, int len, Sortable comp) {
        int a;
        int c;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && comp.compare(j - 1, j) > 0) {
                    comp.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = GenericSorter.med3(l, l + s, l + 2 * s, comp);
                m = GenericSorter.med3(m - s, m, m + s, comp);
                n = GenericSorter.med3(n - 2 * s, n - s, n, comp);
            }
            c = comp.compare(m, n);
            m = comp.compare(l, m) < 0 ? (c < 0 ? m : (comp.compare(l, n) < 0 ? n : l)) : (c > 0 ? m : (comp.compare(l, n) > 0 ? n : l));
        }
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(b, m)) <= 0) {
                if (comparison == 0) {
                    if (a == m) {
                        m = b;
                    } else if (b == m) {
                        m = a;
                    }
                    comp.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(c, m)) >= 0) {
                if (comparison == 0) {
                    if (c == m) {
                        m = d;
                    } else if (d == m) {
                        m = c;
                    }
                    comp.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            if (b == m) {
                m = d;
            } else if (c == m) {
                m = c;
            }
            comp.swap(b++, c--);
        }
        int s = Math.min(a - off, b - a);
        int aa = off;
        int bb = b - s;
        while (--s >= 0) {
            comp.swap(aa++, bb++);
        }
        int n = off + len;
        s = Math.min(d - c, n - d - 1);
        aa = b;
        bb = n - s;
        while (--s >= 0) {
            comp.swap(aa++, bb++);
        }
        s = b - a;
        if (s > 1) {
            GenericSorter.quickSort1(off, s, comp);
        }
        if ((s = d - c) > 1) {
            GenericSorter.quickSort1(n - s, s, comp);
        }
    }

    private static int med3(int a, int b, int c, Sortable comp) {
        int bc = comp.compare(b, c);
        return comp.compare(a, b) < 0 ? (bc < 0 ? b : (comp.compare(a, c) < 0 ? c : a)) : (bc > 0 ? b : (comp.compare(a, c) > 0 ? c : a));
    }

    public static void mergeSort(int fromIndex, int toIndex, Sortable c) {
        if (toIndex - fromIndex < 7) {
            int i = fromIndex;
            while (i < toIndex) {
                int j = i;
                while (j > fromIndex && c.compare(j - 1, j) > 0) {
                    c.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = fromIndex + toIndex >>> 1;
        GenericSorter.mergeSort(fromIndex, mid, c);
        GenericSorter.mergeSort(mid, toIndex, c);
        if (c.compare(mid - 1, mid) <= 0) {
            return;
        }
        GenericSorter.inplaceMerge(fromIndex, mid, toIndex, c);
    }

    private static void inplaceMerge(int first, int middle, int last, Sortable comp) {
        int secondCut;
        int mid;
        int half;
        int len;
        int _first;
        int firstCut;
        if (first >= middle || middle >= last) {
            return;
        }
        if (last - first == 2) {
            if (comp.compare(middle, first) < 0) {
                comp.swap(first, middle);
            }
            return;
        }
        if (middle - first > last - middle) {
            firstCut = first + (middle - first >>> 1);
            _first = middle;
            len = last - _first;
            while (len > 0) {
                half = len >>> 1;
                mid = _first + half;
                if (comp.compare(mid, firstCut) < 0) {
                    _first = mid + 1;
                    len -= half + 1;
                    continue;
                }
                len = half;
            }
            secondCut = _first;
        } else {
            secondCut = middle + (last - middle >>> 1);
            _first = first;
            len = middle - _first;
            while (len > 0) {
                half = len >>> 1;
                mid = _first + half;
                if (comp.compare(secondCut, mid) < 0) {
                    len = half;
                    continue;
                }
                _first = mid + 1;
                len -= half + 1;
            }
            firstCut = _first;
        }
        int first2 = firstCut;
        int middle2 = middle;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                comp.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                comp.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                comp.swap(first1++, last1);
            }
        }
        middle = firstCut + (secondCut - middle);
        GenericSorter.inplaceMerge(first, firstCut, middle, comp);
        GenericSorter.inplaceMerge(middle, secondCut, last, comp);
    }
}

