/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

public class GlobalVariable
extends GeneralVariable
implements Container {
    private Executable executable;
    private SlotManager stackFrameMap = null;
    private boolean indexed;

    @Override
    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    @Override
    public int getHostLanguage() {
        return this.executable.getHostLanguage();
    }

    public void setIndexedVariable() {
        this.indexed = true;
    }

    public boolean isIndexedVariable() {
        return this.indexed;
    }

    @Override
    public int getContainerGranularity() {
        return 2;
    }

    public void setContainsLocals(SlotManager map) {
        this.stackFrameMap = map;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    public void lookForCycles(Stack referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        if (referees.contains(this)) {
            int s = referees.indexOf(this);
            referees.push(this);
            String message = "Circular definition of global variable. $" + this.getVariableQName().getDisplayName();
            int i = s;
            while (i < referees.size() - 1) {
                Container next;
                if (i != s) {
                    message = String.valueOf(message) + ", which";
                }
                if (referees.get(i + 1) instanceof GlobalVariable) {
                    next = (GlobalVariable)referees.get(i + 1);
                    message = String.valueOf(message) + " uses $" + ((GeneralVariable)((Object)next)).getVariableQName().getDisplayName();
                } else if (referees.get(i + 1) instanceof XQueryFunction) {
                    next = (XQueryFunction)referees.get(i + 1);
                    message = String.valueOf(message) + " calls " + ((XQueryFunction)next).getFunctionName().getDisplayName() + "#" + ((XQueryFunction)next).getNumberOfArguments() + "()";
                }
                ++i;
            }
            message = String.valueOf(message) + '.';
            XPathException err = new XPathException(message);
            err.setErrorCode("XQST0054");
            err.setIsStaticError(true);
            err.setLocator(this);
            throw err;
        }
        if (this.select != null) {
            referees.push(this);
            ArrayList list = new ArrayList(10);
            ExpressionTool.gatherReferencedVariables(this.select, list);
            int i = 0;
            while (i < list.size()) {
                Binding b = (Binding)list.get(i);
                if (b instanceof GlobalVariable) {
                    ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
                }
                ++i;
            }
            list.clear();
            ExpressionTool.gatherCalledFunctionNames(this.select, list);
            i = 0;
            while (i < list.size()) {
                XQueryFunction f = globalFunctionLibrary.getDeclarationByKey((String)list.get(i));
                if (!referees.contains(f)) {
                    GlobalVariable.lookForFunctionCycles(f, referees, globalFunctionLibrary);
                }
                ++i;
            }
            referees.pop();
        }
    }

    private static void lookForFunctionCycles(XQueryFunction f, Stack referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        Expression body = f.getBody();
        referees.push(f);
        ArrayList list = new ArrayList(10);
        ExpressionTool.gatherReferencedVariables(body, list);
        int i = 0;
        while (i < list.size()) {
            Binding b = (Binding)list.get(i);
            if (b instanceof GlobalVariable) {
                ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
            }
            ++i;
        }
        list.clear();
        ExpressionTool.gatherCalledFunctionNames(body, list);
        i = 0;
        while (i < list.size()) {
            XQueryFunction qf = globalFunctionLibrary.getDeclarationByKey((String)list.get(i));
            if (!referees.contains(qf)) {
                GlobalVariable.lookForFunctionCycles(qf, referees, globalFunctionLibrary);
            }
            ++i;
        }
        referees.pop();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return null;
    }

    @Override
    public ValueRepresentation getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)("*** No select expression for global variable $" + this.getVariableQName().getDisplayName() + "!!"));
        }
        try {
            XPathContextMajor c2 = context.newCleanContext();
            c2.setOrigin(this);
            UnfailingIterator initialNode = SingletonIterator.makeIterator(c2.getController().getContextForGlobalVariables());
            initialNode.next();
            c2.setCurrentIterator(initialNode);
            if (this.stackFrameMap != null) {
                c2.openStackFrame(this.stackFrameMap);
            }
            return ExpressionTool.evaluate(this.select, this.evaluationMode, c2, this.referenceCount);
        }
        catch (XPathException e) {
            if (!this.getVariableQName().getNamespaceURI().equals("http://saxon.sf.net/generated-global-variable")) {
                e.setIsGlobalError(true);
            }
            throw e;
        }
    }

    @Override
    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        Bindery b = controller.getBindery();
        ValueRepresentation v = b.getGlobalVariable(this.getSlotNumber());
        if (v != null) {
            return v;
        }
        try {
            b.setExecuting(this, true);
            ValueRepresentation value = this.getSelectValue(context);
            if (this.indexed) {
                value = controller.getConfiguration().getOptimizer().makeIndexedValue(Value.asIterator(value));
            }
            b.defineGlobalVariable(this, value);
            b.setExecuting(this, false);
            return value;
        }
        catch (XPathException err) {
            b.setExecuting(this, false);
            if (err instanceof XPathException.Circularity) {
                XPathException e = new XPathException("Circular definition of variable " + this.getVariableQName().getDisplayName());
                int lang = this.getExecutable().getHostLanguage();
                e.setErrorCode(lang == 51 ? "XQST0054" : "XTDE0640");
                e.setXPathContext(context);
                this.select = new ErrorExpression(e);
                e.setLocator(this);
                throw e;
            }
            throw err;
        }
    }
}

