/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class Choose
extends Instruction {
    private Expression[] conditions;
    private Expression[] actions;

    public Choose(Expression[] conditions, Expression[] actions) {
        this.conditions = conditions;
        this.actions = actions;
        if (conditions.length != actions.length) {
            throw new IllegalArgumentException("Choose: unequal length arguments");
        }
        int i = 0;
        while (i < conditions.length) {
            this.adoptChildExpression(conditions[i]);
            this.adoptChildExpression(actions[i]);
            ++i;
        }
    }

    public static Expression makeConditional(Expression condition, Expression thenExp, Expression elseExp) {
        if (Literal.isEmptySequence(elseExp)) {
            Expression[] conditions = new Expression[]{condition};
            Expression[] actions = new Expression[]{thenExp};
            return new Choose(conditions, actions);
        }
        Expression[] conditions = new Expression[]{condition, new Literal(BooleanValue.TRUE)};
        Expression[] actions = new Expression[]{thenExp, elseExp};
        return new Choose(conditions, actions);
    }

    public static Expression makeConditional(Expression condition, Expression thenExp) {
        Expression[] conditions = new Expression[]{condition};
        Expression[] actions = new Expression[]{thenExp};
        return new Choose(conditions, actions);
    }

    public static boolean isSingleBranchChoice(Expression exp) {
        return exp instanceof Choose && ((Choose)exp).conditions.length == 1;
    }

    public Expression[] getConditions() {
        return this.conditions;
    }

    public Expression[] getActions() {
        return this.actions;
    }

    @Override
    public int getInstructionNameCode() {
        return this.conditions.length == 1 ? 150 : 135;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        int i = 0;
        while (i < this.conditions.length) {
            this.conditions[i] = visitor.simplify(this.conditions[i]);
            try {
                this.actions[i] = visitor.simplify(this.actions[i]);
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
            ++i;
        }
        return this;
    }

    private Expression removeRedundantBranches(ExpressionVisitor visitor) {
        Expression[] a;
        Expression[] c;
        int i = 0;
        while (i < this.conditions.length) {
            if (Literal.isConstantBoolean(this.conditions[i], false)) {
                if (this.conditions.length == 1) {
                    Literal lit = new Literal(EmptySequence.getInstance());
                    ExpressionTool.copyLocationInfo(this, lit);
                    return lit;
                }
                c = new Expression[this.conditions.length - 1];
                a = new Expression[this.conditions.length - 1];
                if (i != 0) {
                    System.arraycopy(this.conditions, 0, c, 0, i);
                    System.arraycopy(this.actions, 0, a, 0, i);
                }
                if (i != this.conditions.length) {
                    System.arraycopy(this.conditions, i + 1, c, i, this.conditions.length - i - 1);
                    System.arraycopy(this.actions, i + 1, a, i, this.actions.length - i - 1);
                }
                this.conditions = c;
                this.actions = a;
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.conditions.length - 1) {
            if (Literal.isConstantBoolean(this.conditions[i], true)) {
                if (i == 0) {
                    return this.actions[0];
                }
                c = new Expression[i + 1];
                a = new Expression[i + 1];
                System.arraycopy(this.conditions, 0, c, 0, i + 1);
                System.arraycopy(this.actions, 0, a, 0, i + 1);
                break;
            }
            ++i;
        }
        if (this.conditions.length == 1 && Literal.isConstantBoolean(this.conditions[0], true)) {
            return this.actions[0];
        }
        if (Literal.isEmptySequence(this.actions[this.actions.length - 1])) {
            if (this.conditions.length == 1) {
                return new Literal(EmptySequence.getInstance());
            }
            Expression[] c2 = new Expression[this.conditions.length - 1];
            System.arraycopy(this.conditions, 0, c2, 0, this.conditions.length - 1);
            Expression[] a2 = new Expression[this.actions.length - 1];
            System.arraycopy(this.actions, 0, a2, 0, this.actions.length - 1);
        }
        if (Literal.isConstantBoolean(this.conditions[this.conditions.length - 1], true) && this.actions[this.actions.length - 1] instanceof Choose) {
            Choose choose2 = (Choose)this.actions[this.actions.length - 1];
            int newLen = this.conditions.length + choose2.conditions.length - 1;
            Expression[] c2 = new Expression[newLen];
            Expression[] a2 = new Expression[newLen];
            System.arraycopy(this.conditions, 0, c2, 0, this.conditions.length - 1);
            System.arraycopy(this.actions, 0, a2, 0, this.actions.length - 1);
            System.arraycopy(choose2.conditions, 0, c2, this.conditions.length - 1, choose2.conditions.length);
            System.arraycopy(choose2.actions, 0, a2, this.actions.length - 1, choose2.actions.length);
            this.conditions = c2;
            this.actions = a2;
        }
        if (this.conditions.length == 2 && Literal.isConstantBoolean(this.actions[0], true) && Literal.isConstantBoolean(this.actions[1], false) && Literal.isConstantBoolean(this.conditions[1], true)) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.conditions[0].getItemType(th), BuiltInAtomicType.BOOLEAN) && this.conditions[0].getCardinality() == 16384) {
                return this.conditions[0];
            }
            return SystemFunction.makeSystemFunction("boolean", new Expression[]{this.conditions[0]});
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int i = 0;
        while (i < this.conditions.length) {
            this.conditions[i] = visitor.typeCheck(this.conditions[i], contextItemType);
            XPathException err = TypeChecker.ebvError(this.conditions[i], visitor.getConfiguration().getTypeHierarchy());
            if (err != null) {
                err.setLocator(this.conditions[i]);
                throw err;
            }
            ++i;
        }
        i = 0;
        while (i < this.actions.length) {
            try {
                this.actions[i] = visitor.typeCheck(this.actions[i], contextItemType);
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
            ++i;
        }
        return this.removeRedundantBranches(visitor);
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleLocator role, ExpressionVisitor visitor) throws XPathException {
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i] = TypeChecker.staticTypeCheck(this.actions[i], req, backwardsCompatible, role, visitor);
            ++i;
        }
        if (!Literal.isConstantBoolean(this.conditions[this.conditions.length - 1], true) && !Cardinality.allowsZero(req.getCardinality())) {
            String cond = this.conditions.length == 1 ? "the condition is not" : "none of the conditions is";
            XPathException err = new XPathException("Conditional expression: If " + cond + " satisfied, an empty sequence will be returned, " + "but this is not allowed as the " + role.getMessage());
            err.setErrorCode(role.getErrorCode());
            err.setIsTypeError(true);
            throw err;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int i = 0;
        while (i < this.conditions.length) {
            this.conditions[i] = visitor.optimize(this.conditions[i], contextItemType);
            Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.conditions[i], visitor, contextItemType);
            if (ebv != null && ebv != this.conditions[i]) {
                this.conditions[i] = ebv;
                this.adoptChildExpression(ebv);
            }
            if (this.conditions[i] instanceof Literal && !(((Literal)this.conditions[i]).getValue() instanceof BooleanValue)) {
                boolean b;
                try {
                    b = ((Literal)this.conditions[i]).getValue().effectiveBooleanValue();
                }
                catch (XPathException err) {
                    err.setLocator(this);
                    throw err;
                }
                this.conditions[i] = new Literal(BooleanValue.get(b));
            }
            ++i;
        }
        i = 0;
        while (i < this.actions.length) {
            try {
                this.actions[i] = visitor.optimize(this.actions[i], contextItemType);
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
            ++i;
        }
        if (this.actions.length == 0) {
            return Literal.makeEmptySequence();
        }
        Expression e = this.removeRedundantBranches(visitor);
        if (e instanceof Choose) {
            return visitor.getConfiguration().getOptimizer().trySwitch((Choose)e, visitor.getStaticContext());
        }
        return e;
    }

    @Override
    public Expression copy() {
        Expression[] c2 = new Expression[this.conditions.length];
        Expression[] a2 = new Expression[this.conditions.length];
        int c = 0;
        while (c < this.conditions.length) {
            c2[c] = this.conditions[c].copy();
            a2[c] = this.actions[c].copy();
            ++c;
        }
        return new Choose(c2, a2);
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        int c = 0;
        while (c < this.conditions.length) {
            this.conditions[c].checkForUpdatingSubexpressions();
            if (this.conditions[c].isUpdatingExpression()) {
                XPathException err = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
                err.setLocator(this.conditions[c]);
                throw err;
            }
            ++c;
        }
        boolean updating = false;
        boolean nonUpdating = false;
        int i = 0;
        while (i < this.actions.length) {
            Expression act = this.actions[i];
            act.checkForUpdatingSubexpressions();
            if (!ExpressionTool.isAllowedInUpdatingContext(act)) {
                if (updating) {
                    XPathException err = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                    err.setLocator(this.actions[i]);
                    throw err;
                }
                nonUpdating = true;
            }
            if (act.isUpdatingExpression()) {
                if (nonUpdating) {
                    XPathException err = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                    err.setLocator(this.actions[i]);
                    throw err;
                }
                updating = true;
            }
            ++i;
        }
    }

    @Override
    public boolean isUpdatingExpression() {
        int c = 0;
        while (c < this.actions.length) {
            if (this.actions[c].isUpdatingExpression()) {
                return true;
            }
            ++c;
        }
        return false;
    }

    @Override
    public boolean isVacuousExpression() {
        int c = 0;
        while (c < this.actions.length) {
            if (!this.actions[c].isVacuousExpression()) {
                return false;
            }
            ++c;
        }
        return true;
    }

    @Override
    public int getImplementationMethod() {
        int m = 6;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m |= 1;
        }
        return m;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        int result = 0;
        int i = 0;
        while (i < this.actions.length) {
            result = Math.max(result, this.actions[i].markTailFunctionCalls(qName, arity));
            ++i;
        }
        return result;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        ItemType type = this.actions[0].getItemType(th);
        int i = 1;
        while (i < this.actions.length) {
            type = Type.getCommonSuperType(type, this.actions[i].getItemType(th), th);
            ++i;
        }
        return type;
    }

    @Override
    public int computeCardinality() {
        int card = 0;
        boolean includesTrue = false;
        int i = 0;
        while (i < this.actions.length) {
            card = Cardinality.union(card, this.actions[i].getCardinality());
            if (Literal.isConstantBoolean(this.conditions[i], true)) {
                includesTrue = true;
            }
            ++i;
        }
        if (!includesTrue) {
            card = Cardinality.union(card, 8192);
        }
        return card;
    }

    @Override
    public int computeSpecialProperties() {
        int props = this.actions[0].getSpecialProperties();
        int i = 1;
        while (i < this.actions.length) {
            props &= this.actions[i].getSpecialProperties();
            ++i;
        }
        return props;
    }

    @Override
    public final boolean createsNewNodes() {
        int i = 0;
        while (i < this.actions.length) {
            int props = this.actions[i].getSpecialProperties();
            if ((props & 0x400000) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new Iterator<Expression>(){
            boolean doingConditions = true;
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.doingConditions || this.index < Choose.this.actions.length;
            }

            @Override
            public Expression next() {
                if (this.doingConditions) {
                    if (this.index < Choose.this.conditions.length) {
                        return Choose.this.conditions[this.index++];
                    }
                    this.doingConditions = false;
                    this.index = 0;
                    return Choose.this.actions[this.index++];
                }
                if (this.index < Choose.this.actions.length) {
                    return Choose.this.actions[this.index++];
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        int i = 0;
        while (i < this.conditions.length) {
            if (this.conditions[i] == original) {
                this.conditions[i] = replacement;
                found = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.actions.length) {
            if (this.actions[i] == original) {
                this.actions[i] = replacement;
                found = true;
            }
            ++i;
        }
        return found;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (offer.action == 13 || offer.action == 12 || offer.action == 14) {
            int i = 0;
            while (i < this.conditions.length) {
                this.conditions[i] = this.doPromotion(this, this.conditions[i], offer);
                ++i;
            }
            i = 0;
            while (i < this.actions.length) {
                this.actions[i] = this.doPromotion(this, this.actions[i], offer);
                ++i;
            }
        } else {
            this.conditions[0] = this.doPromotion(this, this.conditions[0], offer);
        }
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].checkPermittedContents(parentType, env, whole);
            ++i;
        }
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        int i = 0;
        while (i < this.conditions.length) {
            this.conditions[i].addToPathMap(pathMap, pathMapNodeSet);
            ++i;
        }
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        int i2 = 0;
        while (i2 < this.actions.length) {
            PathMap.PathMapNodeSet temp = this.actions[i2].addToPathMap(pathMap, pathMapNodeSet);
            result.addNodeSet(temp);
            ++i2;
        }
        return result;
    }

    @Override
    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append("if (");
        int i = 0;
        while (i < this.conditions.length) {
            sb.append(this.conditions[i].toString());
            sb.append(") then (");
            sb.append(this.actions[i].toString());
            if (i == this.conditions.length - 1) {
                sb.append(")");
            } else {
                sb.append(") else if (");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("choose");
        int i = 0;
        while (i < this.conditions.length) {
            out.startSubsidiaryElement("when");
            this.conditions[i].explain(out);
            out.endSubsidiaryElement();
            out.startSubsidiaryElement("then");
            this.actions[i].explain(out);
            out.endSubsidiaryElement();
            ++i;
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        int i = 0;
        while (i < this.conditions.length) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.conditions[i]);
                throw e;
            }
            if (b) {
                if (this.actions[i] instanceof TailCallReturner) {
                    return ((TailCallReturner)((Object)this.actions[i])).processLeavingTail(context);
                }
                this.actions[i].process(context);
                return null;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        int i = 0;
        while (i < this.conditions.length) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.conditions[i]);
                throw e;
            }
            if (b) {
                return this.actions[i].evaluateItem(context);
            }
            ++i;
        }
        return null;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int i = 0;
        while (i < this.conditions.length) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.conditions[i]);
                throw e;
            }
            if (b) {
                return this.actions[i].iterate(context);
            }
            ++i;
        }
        return EmptyIterator.getInstance();
    }

    @Override
    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        int i = 0;
        while (i < this.conditions.length) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.conditions[i]);
                throw e;
            }
            if (b) {
                return this.actions[i].iterateEvents(context);
            }
            ++i;
        }
        return EmptyEventIterator.getInstance();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        int i = 0;
        while (i < this.conditions.length) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.conditions[i]);
                throw e;
            }
            if (b) {
                this.actions[i].evaluatePendingUpdates(context, pul);
                return;
            }
            ++i;
        }
    }
}

