/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.regex.JRegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class Matches
extends SystemFunction {
    private RegularExpression regexp;

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression e = this.simplifyArguments(visitor);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    private void maybePrecompile(ExpressionVisitor visitor) throws XPathException {
        if (this.regexp == null) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 2, visitor.getStaticContext());
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        RegularExpression re;
        AtomicValue sv0 = (AtomicValue)this.argument[0].evaluateItem(c);
        if (sv0 == null) {
            sv0 = StringValue.EMPTY_STRING;
        }
        if ((re = this.regexp) == null) {
            CharSequence flags;
            AtomicValue pat = (AtomicValue)this.argument[1].evaluateItem(c);
            if (pat == null) {
                return null;
            }
            if (this.argument.length == 2) {
                flags = "";
            } else {
                AtomicValue sv2 = (AtomicValue)this.argument[2].evaluateItem(c);
                if (sv2 == null) {
                    return null;
                }
                flags = sv2.getStringValueCS();
            }
            try {
                int xmlVersion = c.getConfiguration().getXMLVersion();
                int flagBits = JRegularExpression.setFlags(flags);
                re = new JRegularExpression(pat.getStringValueCS(), xmlVersion, 0, flagBits);
            }
            catch (XPathException err) {
                XPathException de = new XPathException(err);
                de.maybeSetErrorCode("FORX0002");
                de.setXPathContext(c);
                throw de;
            }
        }
        return BooleanValue.get(re.containsMatch(sv0.getStringValueCS()));
    }

    public static RegularExpression tryToCompile(Expression[] args, int patternArg, int flagsArg, StaticContext env) throws XPathException {
        if (patternArg > args.length - 1) {
            return null;
        }
        CharSequence flagstr = null;
        if (args.length - 1 < flagsArg) {
            flagstr = "";
        } else if (args[flagsArg] instanceof StringLiteral) {
            flagstr = ((StringLiteral)args[flagsArg]).getStringValue();
        }
        if (args[patternArg] instanceof StringLiteral && flagstr != null) {
            try {
                Configuration.getPlatform();
                String in = ((StringLiteral)args[patternArg]).getStringValue();
                int xmlVersion = env.getConfiguration().getXMLVersion();
                int syntax = 0;
                if (flagstr.length() > 0 && flagstr.charAt(0) == '!') {
                    flagstr = flagstr.subSequence(1, flagstr.length());
                    syntax = 2;
                }
                int flagBits = JRegularExpression.setFlags(flagstr);
                return new JRegularExpression(in, xmlVersion, syntax, flagBits);
            }
            catch (XPathException err) {
                err.maybeSetErrorCode("FORX0002");
                throw err;
            }
        }
        return null;
    }
}

