/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReverseRangeIterator;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;

public class RangeIterator
implements SequenceIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator {
    long start;
    long currentValue;
    long limit;

    public RangeIterator(long start, long end) {
        this.start = start;
        this.currentValue = start - 1L;
        this.limit = end;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue < this.limit;
    }

    @Override
    public Item next() {
        if (++this.currentValue > this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public Item current() {
        if (this.currentValue > this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public int position() {
        if (this.currentValue > this.limit) {
            return -1;
        }
        return (int)(this.currentValue - this.start + 1L);
    }

    @Override
    public void close() {
    }

    @Override
    public int getLastPosition() {
        return (int)(this.limit - this.start + 1L);
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        return new RangeIterator(this.start, this.limit);
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public SequenceIterator getReverseIterator() {
        return new ReverseRangeIterator(this.limit, this.start);
    }

    @Override
    public GroundedValue materialize() throws XPathException {
        return new IntegerRange(this.start, this.limit);
    }
}

