/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import net.sf.saxon.codenorm.Normalizer;
import net.sf.saxon.event.HTMLURIEscaper;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public class XHTMLURIEscaper
extends HTMLURIEscaper {
    private HashSet urlTable;

    private synchronized void buildURIAttributeTable() {
        NamePool pool = this.getPipelineConfiguration().getConfiguration().getNamePool();
        this.urlTable = (HashSet)pool.getClientData(this.getClass());
        if (this.urlTable == null) {
            this.urlTable = new HashSet(40);
            pool.setClientData(this.getClass(), this.urlTable);
        }
        this.setUrlAttribute(pool, "form", "action");
        this.setUrlAttribute(pool, "object", "archive");
        this.setUrlAttribute(pool, "body", "background");
        this.setUrlAttribute(pool, "q", "cite");
        this.setUrlAttribute(pool, "blockquote", "cite");
        this.setUrlAttribute(pool, "del", "cite");
        this.setUrlAttribute(pool, "ins", "cite");
        this.setUrlAttribute(pool, "object", "classid");
        this.setUrlAttribute(pool, "object", "codebase");
        this.setUrlAttribute(pool, "applet", "codebase");
        this.setUrlAttribute(pool, "object", "data");
        this.setUrlAttribute(pool, "button", "datasrc");
        this.setUrlAttribute(pool, "div", "datasrc");
        this.setUrlAttribute(pool, "input", "datasrc");
        this.setUrlAttribute(pool, "object", "datasrc");
        this.setUrlAttribute(pool, "select", "datasrc");
        this.setUrlAttribute(pool, "span", "datasrc");
        this.setUrlAttribute(pool, "table", "datasrc");
        this.setUrlAttribute(pool, "textarea", "datasrc");
        this.setUrlAttribute(pool, "script", "for");
        this.setUrlAttribute(pool, "a", "href");
        this.setUrlAttribute(pool, "a", "name");
        this.setUrlAttribute(pool, "area", "href");
        this.setUrlAttribute(pool, "link", "href");
        this.setUrlAttribute(pool, "base", "href");
        this.setUrlAttribute(pool, "img", "longdesc");
        this.setUrlAttribute(pool, "frame", "longdesc");
        this.setUrlAttribute(pool, "iframe", "longdesc");
        this.setUrlAttribute(pool, "head", "profile");
        this.setUrlAttribute(pool, "script", "src");
        this.setUrlAttribute(pool, "input", "src");
        this.setUrlAttribute(pool, "frame", "src");
        this.setUrlAttribute(pool, "iframe", "src");
        this.setUrlAttribute(pool, "img", "src");
        this.setUrlAttribute(pool, "img", "usemap");
        this.setUrlAttribute(pool, "input", "usemap");
        this.setUrlAttribute(pool, "object", "usemap");
    }

    private void setUrlAttribute(NamePool pool, String element, String attribute) {
        int elcode = pool.allocate("", "http://www.w3.org/1999/xhtml", element) & 0xFFFFF;
        int atcode = pool.allocate("", "", attribute) & 0xFFFFF;
        Long key = new Long((long)elcode << 32 | (long)atcode);
        this.urlTable.add(key);
    }

    private boolean isURLAttribute(int elcode, int atcode) {
        Long key = new Long((long)(elcode &= 0xFFFFF) << 32 | (long)(atcode &= 0xFFFFF));
        return this.urlTable.contains(key);
    }

    @Override
    public void open() throws XPathException {
        super.open();
        if (this.escapeURIAttributes) {
            this.buildURIAttributeTable();
        }
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.escapeURIAttributes && this.isURLAttribute(this.currentElement, nameCode) && (properties & 1) == 0) {
            CharSequence normalized = new Normalizer(2).normalize(value);
            this.getUnderlyingReceiver().attribute(nameCode, typeCode, HTMLURIEscaper.escapeURL(normalized, true), locationId, properties | 2);
        } else {
            this.getUnderlyingReceiver().attribute(nameCode, typeCode, value, locationId, properties);
        }
    }
}

