/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public class NamePoolConverter
extends ProxyReceiver {
    NamePool oldPool;
    NamePool newPool;

    public NamePoolConverter(NamePool oldPool, NamePool newPool) {
        this.oldPool = oldPool;
        this.newPool = newPool;
    }

    @Override
    public void setUnderlyingReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        int nc = this.newPool.allocate(this.oldPool.getPrefix(nameCode), this.oldPool.getURI(nameCode), this.oldPool.getLocalName(nameCode));
        this.nextReceiver.startElement(nc, typeCode, locationId, properties);
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        int nc = this.newPool.allocateNamespaceCode(this.oldPool.getPrefixFromNamespaceCode(namespaceCode), this.oldPool.getURIFromNamespaceCode(namespaceCode));
        this.nextReceiver.namespace(nc, properties);
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        int nc = this.newPool.allocate(this.oldPool.getPrefix(nameCode), this.oldPool.getURI(nameCode), this.oldPool.getLocalName(nameCode));
        this.nextReceiver.attribute(nc, typeCode, value, locationId, properties);
    }
}

