/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import net.sf.saxon.charcode.UTF8CharacterSet;
import net.sf.saxon.codenorm.Normalizer;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public class HTMLURIEscaper
extends ProxyReceiver {
    private static HTMLTagHashSet urlAttributes = new HTMLTagHashSet(47);
    private static HTMLTagHashSet urlCombinations = new HTMLTagHashSet(101);
    private HashMap<Long, Boolean> urlAttributeCache = new HashMap(30);
    protected int currentElement;
    protected boolean escapeURIAttributes = true;
    protected NamePool pool;

    static {
        HTMLURIEscaper.setUrlAttribute("form", "action");
        HTMLURIEscaper.setUrlAttribute("object", "archive");
        HTMLURIEscaper.setUrlAttribute("body", "background");
        HTMLURIEscaper.setUrlAttribute("q", "cite");
        HTMLURIEscaper.setUrlAttribute("blockquote", "cite");
        HTMLURIEscaper.setUrlAttribute("del", "cite");
        HTMLURIEscaper.setUrlAttribute("ins", "cite");
        HTMLURIEscaper.setUrlAttribute("object", "classid");
        HTMLURIEscaper.setUrlAttribute("object", "codebase");
        HTMLURIEscaper.setUrlAttribute("applet", "codebase");
        HTMLURIEscaper.setUrlAttribute("object", "data");
        HTMLURIEscaper.setUrlAttribute("button", "datasrc");
        HTMLURIEscaper.setUrlAttribute("div", "datasrc");
        HTMLURIEscaper.setUrlAttribute("input", "datasrc");
        HTMLURIEscaper.setUrlAttribute("object", "datasrc");
        HTMLURIEscaper.setUrlAttribute("select", "datasrc");
        HTMLURIEscaper.setUrlAttribute("span", "datasrc");
        HTMLURIEscaper.setUrlAttribute("table", "datasrc");
        HTMLURIEscaper.setUrlAttribute("textarea", "datasrc");
        HTMLURIEscaper.setUrlAttribute("script", "for");
        HTMLURIEscaper.setUrlAttribute("a", "href");
        HTMLURIEscaper.setUrlAttribute("a", "name");
        HTMLURIEscaper.setUrlAttribute("area", "href");
        HTMLURIEscaper.setUrlAttribute("link", "href");
        HTMLURIEscaper.setUrlAttribute("base", "href");
        HTMLURIEscaper.setUrlAttribute("img", "longdesc");
        HTMLURIEscaper.setUrlAttribute("frame", "longdesc");
        HTMLURIEscaper.setUrlAttribute("iframe", "longdesc");
        HTMLURIEscaper.setUrlAttribute("head", "profile");
        HTMLURIEscaper.setUrlAttribute("script", "src");
        HTMLURIEscaper.setUrlAttribute("input", "src");
        HTMLURIEscaper.setUrlAttribute("frame", "src");
        HTMLURIEscaper.setUrlAttribute("iframe", "src");
        HTMLURIEscaper.setUrlAttribute("img", "src");
        HTMLURIEscaper.setUrlAttribute("img", "usemap");
        HTMLURIEscaper.setUrlAttribute("input", "usemap");
        HTMLURIEscaper.setUrlAttribute("object", "usemap");
    }

    private static void setUrlAttribute(String element, String attribute) {
        urlAttributes.add(attribute);
        urlCombinations.add(String.valueOf(element) + '+' + attribute);
    }

    public boolean isUrlAttribute(int element, int attribute) {
        String attributeName;
        Long key = new Long((long)element << 32 | (long)attribute);
        Boolean result = this.urlAttributeCache.get(key);
        if (result != null) {
            return result;
        }
        if (this.pool == null) {
            this.pool = this.getNamePool();
        }
        if (!urlAttributes.contains(attributeName = this.pool.getDisplayName(attribute))) {
            this.urlAttributeCache.put(key, Boolean.FALSE);
            return false;
        }
        String elementName = this.pool.getDisplayName(element);
        boolean b = urlCombinations.contains(String.valueOf(elementName) + '+' + attributeName);
        this.urlAttributeCache.put(key, b);
        return b;
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.nextReceiver.startDocument(properties);
        this.pool = this.getPipelineConfiguration().getConfiguration().getNamePool();
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.currentElement = nameCode;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.escapeURIAttributes && this.isUrlAttribute(this.currentElement, nameCode) && (properties & 1) == 0) {
            this.nextReceiver.attribute(nameCode, typeCode, HTMLURIEscaper.escapeURL(value, true), locationId, properties | 2);
        } else {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    public static CharSequence escapeURL(CharSequence url, boolean normalize) {
        int i = url.length() - 1;
        while (i >= 0) {
            char ch = url.charAt(i);
            if (ch < ' ' || ch > '~') {
                if (normalize) {
                    CharSequence normalized = new Normalizer(2).normalize(url);
                    return HTMLURIEscaper.reallyEscapeURL(normalized);
                }
                return HTMLURIEscaper.reallyEscapeURL(url);
            }
            --i;
        }
        return url;
    }

    private static CharSequence reallyEscapeURL(CharSequence url) {
        FastStringBuffer sb = new FastStringBuffer(url.length() + 20);
        byte[] array = new byte[4];
        int i = 0;
        while (i < url.length()) {
            char ch = url.charAt(i);
            if (ch < ' ' || ch > '~') {
                int used = UTF8CharacterSet.getUTF8Encoding(ch, i + 1 < url.length() ? url.charAt(i + 1) : (char)' ', array);
                int b = 0;
                while (b < used) {
                    int v = array[b] & 0xFF;
                    sb.append('%');
                    sb.append("0123456789ABCDEF".charAt(v / 16));
                    sb.append("0123456789ABCDEF".charAt(v % 16));
                    ++b;
                }
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb;
    }
}

