/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.XPathException;

public class CommentStripper
extends ProxyReceiver {
    private CompressedWhitespace savedWhitespace = null;
    private FastStringBuffer buffer = new FastStringBuffer(256);
    static int seq = 0;

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.flush();
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.nextReceiver.endElement();
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (chars instanceof CompressedWhitespace) {
            if (this.buffer.length() == 0 && this.savedWhitespace == null) {
                this.savedWhitespace = (CompressedWhitespace)chars;
            } else {
                ((CompressedWhitespace)chars).uncompress(this.buffer);
            }
        } else {
            if (this.savedWhitespace != null) {
                this.savedWhitespace.uncompress(this.buffer);
                this.savedWhitespace = null;
            }
            this.buffer.append(chars);
        }
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) {
    }

    @Override
    public void processingInstruction(String name, CharSequence data, int locationId, int properties) {
    }

    private void flush() throws XPathException {
        if (this.buffer.length() > 0) {
            this.nextReceiver.characters(this.buffer, 0, 0);
        } else if (this.savedWhitespace != null) {
            this.nextReceiver.characters(this.savedWhitespace, 0, 0);
        }
        this.savedWhitespace = null;
        this.buffer.setLength(0);
    }
}

