/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.utiltests;

import junit.framework.TestCase;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;

public class ArgsUtilTest
extends TestCase {
    private static String QUOTE = "\"";
    private static String EQ = "=";

    public void testParse() {
        ArgsUtilTest.assertEquals((int)1, (int)ArgsUtil.parse((String)"").length);
        ArgsUtilTest.assertEquals((int)1, (int)ArgsUtil.parse((String)"a").length);
        ArgsUtilTest.assertEquals((int)1, (int)ArgsUtil.parse((String)"abc ").length);
        ArgsUtilTest.assertEquals((int)1, (int)ArgsUtil.parse((String)" abcde ").length);
        ArgsUtilTest.assertEquals((int)1, (int)ArgsUtil.parse((String)"   abcde ").length);
        ArgsUtilTest.assertEquals((int)1, (int)ArgsUtil.parse((String)"   abcde   ").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)"a b").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)"a  b").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)" a  b").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)" a b  ").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)"-b test  ").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)"-b --host=someval  ").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)"-b \"--host=some val\"").length);
        ArgsUtilTest.assertEquals((int)3, (int)ArgsUtil.parse((String)"-b val --host=someval").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)"-b --host=\"some val\"").length);
        ArgsUtilTest.assertEquals((int)2, (int)ArgsUtil.parse((String)"-b \"--host=some val\"").length);
    }

    public void testShortArgMatch() {
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.matchesShortArg((String)"-b", (String[])this.split("-b -c -d -f")));
        ArgsUtilTest.assertFalse((boolean)ArgsUtil.matchesShortArg((String)"-b", (String[])this.split("-c opt d two -f")));
        ArgsUtilTest.assertFalse((boolean)ArgsUtil.matchesShortArg((String)"-b", (String[])this.split("b")));
        ArgsUtilTest.assertFalse((boolean)ArgsUtil.matchesShortArg((String)"-b", (String[])this.split("b opt")));
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.matchesShortArg((String)"-b", (String[])this.split("-b opt")));
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.matchesShortArg((String)"-host", (String[])this.split("-host -c -d -f")));
        ArgsUtilTest.assertFalse((boolean)ArgsUtil.matchesShortArg((String)"-host", (String[])this.split("-c val d two -f")));
        ArgsUtilTest.assertFalse((boolean)ArgsUtil.matchesShortArg((String)"-host", (String[])this.split("host")));
        ArgsUtilTest.assertFalse((boolean)ArgsUtil.matchesShortArg((String)"-host", (String[])this.split("host val")));
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.matchesShortArg((String)"-host", (String[])this.split("-host val")));
    }

    public void testLongArgMatch() {
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.matchesLongArg((String)"--host=localhost", (String[])this.split("--host --longopt1 -longopt2 -f")));
        ArgsUtilTest.assertFalse((boolean)ArgsUtil.matchesLongArg((String)"-host=localhost", (String[])this.split("--host --longopt1 -longopt2 -f")));
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.matchesLongArg((String)"-longopt2=v1", (String[])this.split("--host --longopt1 -longopt2 -f")));
        ArgsUtilTest.assertFalse((boolean)ArgsUtil.matchesLongArg((String)"-longopt2 v1", (String[])this.split("--host --longopt1 -longopt2 -f")));
    }

    public void testReplace() {
        String allArgs = "";
        ArgsUtilTest.assertTrue((ArgsUtil.parse((String)(allArgs = ArgsUtil.setArg((String)allArgs, (String)"-h", null, (String)"new"))).length == 2 ? 1 : 0) != 0);
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, (String)"-h", null).equals("new"));
        allArgs = ArgsUtil.setArg((String)allArgs, (String)"-h", null, (String)"correct");
        ArgsUtilTest.assertTrue((ArgsUtil.parse((String)allArgs).length == 2 ? 1 : 0) != 0);
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, (String)"-h", null).equals("correct"));
        allArgs = ArgsUtil.setArg((String)allArgs, null, (String)"--two", (String)"newtwo");
        ArgsUtilTest.assertTrue((ArgsUtil.parse((String)allArgs).length == 3 ? 1 : 0) != 0);
        ArgsUtilTest.assertTrue((ArgsUtil.getValue((String)allArgs, (String)"--two", null) == null ? 1 : 0) != 0);
        allArgs = ArgsUtil.setArg((String)allArgs, null, (String)"--two", null);
        ArgsUtilTest.assertTrue((ArgsUtil.parse((String)allArgs).length == 2 ? 1 : 0) != 0);
        allArgs = ArgsUtil.setArg((String)allArgs, (String[])new String[]{"-h", "-o"}, (String[])new String[0], (String)"twoOpt", (boolean)false);
        ArgsUtilTest.assertTrue((ArgsUtil.parse((String)allArgs).length == 2 ? 1 : 0) != 0);
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, (String)"-h", null).equals("twoOpt"));
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, (String[])new String[]{"-h", "-o"}, null).equals("twoOpt"));
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, (String[])new String[]{"-o", "-h"}, null).equals("twoOpt"));
        allArgs = ArgsUtil.setArg((String)allArgs, (String[])new String[]{"-h", "-o"}, (String[])new String[0], null, (boolean)false);
        ArgsUtilTest.assertTrue((ArgsUtil.parse((String)allArgs).length == 1 ? 1 : 0) != 0);
        allArgs = ArgsUtil.setArg((String)allArgs, null, (String)"--three", (String)"three");
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, null, (String)"--three").equals("three"));
        allArgs = ArgsUtil.setArg((String)allArgs, null, (String)"--three", (String)"threea");
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, null, (String)"--three").equals("threea"));
        ArgsUtilTest.assertTrue((boolean)allArgs.contains("--three"));
        allArgs = ArgsUtil.setArg((String)allArgs, null, (String[])new String[]{"--four", "--three"}, (String)"three_b", (boolean)false);
        ArgsUtilTest.assertTrue((boolean)allArgs.contains("--four"));
        ArgsUtilTest.assertTrue((ArgsUtil.getValue((String)allArgs, null, (String)"--three") == null ? 1 : 0) != 0);
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, null, (String)"--four").equals("three_b"));
        ArgsUtilTest.assertTrue((boolean)ArgsUtil.getValue((String)allArgs, null, (String[])new String[]{"--three", "--four"}).equals("three_b"));
    }

    public void testOuterQuoteMultipleSet() {
        String argId = "-Dtest";
        String folder = "my folder";
        String args = String.valueOf(QUOTE) + argId + EQ + folder + QUOTE;
        String args2 = ArgsUtil.setArg((String)args, null, (String)argId, (String)folder);
        ArgsUtilTest.assertTrue((boolean)args2.trim().equals(args));
        String args3 = ArgsUtil.setArg((String)args2, null, (String)argId, (String)(String.valueOf(folder) + "2"));
        ArgsUtilTest.assertTrue((boolean)args3.trim().equals(String.valueOf(QUOTE) + argId + EQ + folder + "2" + QUOTE));
    }

    public void testInnerQuotesMultipleSet() {
        String argId = "-Dtest";
        String folder = "my folder";
        String args = String.valueOf(argId) + EQ + QUOTE + folder + QUOTE;
        String args2 = ArgsUtil.setArg((String)args, null, (String)argId, (String)(String.valueOf(folder) + "2"));
        ArgsUtilTest.assertTrue((boolean)args2.trim().equals(String.valueOf(argId) + EQ + QUOTE + folder + "2" + QUOTE));
        args2 = ArgsUtil.setArg((String)args2, null, (String)argId, (String)(String.valueOf(folder) + "3"));
        ArgsUtilTest.assertTrue((boolean)args2.trim().equals(String.valueOf(argId) + EQ + QUOTE + folder + "3" + QUOTE));
    }

    public void testSetToNulLWithQuotes() {
        String argId = "-Dtest";
        String folder = "my folder";
        String args = String.valueOf(QUOTE) + argId + EQ + folder + QUOTE;
        String args2 = ArgsUtil.setArg((String)args, null, (String)argId, null, (boolean)true);
        ArgsUtilTest.assertTrue((boolean)args2.trim().equals(""));
    }

    public String[] split(String val) {
        return val.split(" ");
    }

    public void testSettingFlag() {
        String original = "-Dsome.name=yes -server -Darg2=no";
        String[] asArray = ArgsUtil.parse((String)original);
        ArgsUtilTest.assertEquals((int)3, (int)asArray.length);
        String cleared = ArgsUtil.clearFlag((String)original, (String)"-server");
        ArgsUtilTest.assertEquals((String)"-Dsome.name=yes -Darg2=no", (String)cleared);
        String set = ArgsUtil.setFlag((String)cleared, (String)"-ser3");
        ArgsUtilTest.assertEquals((String)"-Dsome.name=yes -Darg2=no -ser3", (String)set);
    }
}

