/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.tools.as.core.server.controllable.subsystems.internal.StandardModuleRestartBehaviorController;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ModuleRestartBehaviorControllerTest
extends TestCase {
    private IServer server;

    @Before
    public void setUp() {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime("org.jboss.ide.eclipse.as.systemCopyServer", String.valueOf(((Object)((Object)this)).getClass().getName()) + "org.jboss.ide.eclipse.as.systemCopyServer");
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Test
    public void testNoPattern() throws CoreException {
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), null);
        StandardModuleRestartBehaviorController controller = new StandardModuleRestartBehaviorController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule testModule = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)testModule.loadAdapter(ModuleDelegate.class, null);
        boolean ret = controller.moduleRequiresRestart(null, md.members());
        ModuleRestartBehaviorControllerTest.assertTrue((boolean)ret);
    }

    @Test
    public void testTxtPattern() throws CoreException {
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), null);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        wc.setAttribute("org.jboss.tools.as.restartFilePattern", "\\.txt$");
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), (String)"\\.txt$");
        StandardModuleRestartBehaviorController controller = new StandardModuleRestartBehaviorController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule testModule = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)testModule.loadAdapter(ModuleDelegate.class, null);
        boolean ret = controller.moduleRequiresRestart(null, md.members());
        ModuleRestartBehaviorControllerTest.assertTrue((boolean)ret);
    }

    @Test
    public void testMissingExtPattern() throws CoreException {
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), null);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        wc.setAttribute("org.jboss.tools.as.restartFilePattern", "\\.svg$");
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), (String)"\\.svg$");
        StandardModuleRestartBehaviorController controller = new StandardModuleRestartBehaviorController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule testModule = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)testModule.loadAdapter(ModuleDelegate.class, null);
        boolean ret = controller.moduleRequiresRestart(null, md.members());
        ModuleRestartBehaviorControllerTest.assertFalse((boolean)ret);
    }

    @Test
    public void testNoPatternDelta() throws CoreException {
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), null);
        StandardModuleRestartBehaviorController controller = new StandardModuleRestartBehaviorController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule testModule = this.createTestMockModule();
        boolean ret = controller.moduleRequiresRestart(null, this.createDelta(testModule));
        ModuleRestartBehaviorControllerTest.assertTrue((boolean)ret);
    }

    @Test
    public void testTxtPatternDelta() throws CoreException {
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), null);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        wc.setAttribute("org.jboss.tools.as.restartFilePattern", "\\.txt$");
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), (String)"\\.txt$");
        StandardModuleRestartBehaviorController controller = new StandardModuleRestartBehaviorController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule testModule = this.createTestMockModule();
        boolean ret = controller.moduleRequiresRestart(null, this.createDelta(testModule));
        ModuleRestartBehaviorControllerTest.assertTrue((boolean)ret);
    }

    @Test
    public void testMissingExtPatternDelta() throws CoreException {
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), null);
        wc.setAttribute("org.jboss.tools.as.restartFilePattern", "\\.svg$");
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), (String)"\\.svg$");
        StandardModuleRestartBehaviorController controller = new StandardModuleRestartBehaviorController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule testModule = this.createTestMockModule();
        boolean ret = controller.moduleRequiresRestart(null, this.createDelta(testModule));
        ModuleRestartBehaviorControllerTest.assertFalse((boolean)ret);
    }

    @Test
    public void testDeepTxtPatternDelta() throws CoreException {
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), null);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        wc.setAttribute("org.jboss.tools.as.restartFilePattern", "F.*txt$");
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), (String)"F.*txt$");
        StandardModuleRestartBehaviorController controller = new StandardModuleRestartBehaviorController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule testModule = this.createTestMockModule();
        boolean ret = controller.moduleRequiresRestart(null, this.createDelta(testModule));
        ModuleRestartBehaviorControllerTest.assertTrue((boolean)ret);
    }

    @Test
    public void testDeepTxtPatternDeltaNotFound() throws CoreException {
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), null);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        wc.setAttribute("org.jboss.tools.as.restartFilePattern", "b.*txt$");
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        ModuleRestartBehaviorControllerTest.assertEquals((String)this.server.getAttribute("org.jboss.tools.as.restartFilePattern", null), (String)"b.*txt$");
        StandardModuleRestartBehaviorController controller = new StandardModuleRestartBehaviorController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule testModule = this.createTestMockModule();
        boolean ret = controller.moduleRequiresRestart(null, this.createDelta(testModule));
        ModuleRestartBehaviorControllerTest.assertFalse((boolean)ret);
    }

    private IModuleResourceDelta[] createDelta(IModule m) throws CoreException {
        ArrayList<IModuleResource> l = new ArrayList<IModuleResource>();
        IModuleResource[] all = MockModuleUtil.getAllResources(this.getResources(m));
        l.addAll(Arrays.asList(all));
        return MockModuleUtil.createMockResourceDeltas(l);
    }

    private IModuleResource[] getResources(IModule m) throws CoreException {
        ModuleDelegate md = (ModuleDelegate)m.loadAdapter(ModuleDelegate.class, null);
        return md.members();
    }

    private IModule createTestMockModule() {
        MockModule m = MockModuleUtil.createMockWebModule();
        IPath[] leafs = new IPath[]{new Path("w"), new Path("x"), new Path("y"), new Path("z"), new Path("a/a1"), new Path("a/a2"), new Path("a/q1"), new Path("a/q2"), new Path("b/b1"), new Path("b/b2"), new Path("b/b3"), new Path("b/b4"), new Path("c/y1"), new Path("c/y2.png"), new Path("c/y3.jpg"), new Path("c/y4.pdf"), new Path("d/F/f1.jar"), new Path("d/F/f2.txt"), new Path("d/F/f3.txt"), new Path("d/F/f4.txt")};
        IModuleResource[] all = MockModuleUtil.createMockResources(leafs, new IPath[0]);
        m.setMembers(all);
        return m;
    }
}

