/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.io.File;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.SubsystemModel;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.jboss.tools.as.test.core.subsystems.ServerSubsystemTest1;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ModuleDeployPathControllerTest
extends TestCase {
    private static String SYSTEM = "moduleDeployPath";
    private static String SUBSYSTEM = "moduleDeployPath.xmlprefs";
    private IServer server;

    @Before
    public void setUp() {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime("org.jboss.ide.eclipse.as.systemCopyServer", String.valueOf(((Object)((Object)this)).getClass().getName()) + "org.jboss.ide.eclipse.as.systemCopyServer");
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Test
    public void testResolution() {
        ServerSubsystemTest1.ModelSubclass c = new ServerSubsystemTest1.ModelSubclass();
        String serverType = "org.jboss.ide.eclipse.as.systemCopyServer";
        String system = SYSTEM;
        String subsystem = SUBSYSTEM;
        SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings(serverType, system);
        ModuleDeployPathControllerTest.assertTrue((types != null ? 1 : 0) != 0);
        ModuleDeployPathControllerTest.assertTrue((types.length == 1 ? 1 : 0) != 0);
        try {
            ISubsystemController controller = c.createSubsystemController((IServerAttributes)this.server, system, null, null, null);
            ModuleDeployPathControllerTest.assertNotNull((Object)controller);
            ModuleDeployPathControllerTest.assertTrue((boolean)controller.getSubsystemMappedId().equals(subsystem));
            ModuleDeployPathControllerTest.assertTrue((boolean)(controller instanceof IModuleDeployPathController));
            ModuleDeployPathControllerTest.assertFalse((boolean)controller.validate().isOK());
        }
        catch (CoreException ce) {
            ModuleDeployPathControllerTest.fail((String)ce.getMessage());
        }
    }

    @Test
    public void testSimpleEnv() {
        IModuleDeployPathController contr = this.buildEnv("/home/user/tmp", "/home/user/tmp2", null);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        contr = this.buildEnv("/home/user/tmp", null, null);
        ModuleDeployPathControllerTest.assertFalse((boolean)contr.validate().isOK());
        contr = this.buildEnv(null, "/home/user/tmp", null);
        ModuleDeployPathControllerTest.assertFalse((boolean)contr.validate().isOK());
    }

    @Test
    public void testGettersNoPrefs() {
        String initialDeployDir = "/home/user/tmp";
        String initialTmpDeployDir = "/home/user/tmp2";
        IModuleDeployPathController contr = this.buildEnv(initialDeployDir, initialTmpDeployDir, null);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        ModuleDeployPathControllerTest.assertEquals((String)".war", (String)contr.getDefaultSuffix((IModule)MockModuleUtil.createMockWebModule()));
        ModuleDeployPathControllerTest.assertEquals((String)".jar", (String)contr.getDefaultSuffix((IModule)MockModuleUtil.createMockUtilModule()));
        ModuleDeployPathControllerTest.assertEquals((String)".ear", (String)contr.getDefaultSuffix((IModule)MockModuleUtil.createMockEarModule()));
        String tmpDir = contr.getTemporaryDeployDirectory(this.asArray(MockModuleUtil.createMockWebModule())).toOSString();
        ModuleDeployPathControllerTest.assertEquals((String)tmpDir, (String)initialTmpDeployDir);
        String depDir = contr.getDeployDirectory(this.asArray(MockModuleUtil.createMockWebModule())).toOSString();
        String expected = String.valueOf(initialDeployDir) + "/" + MockModuleUtil.createMockWebModule().getName() + ".war";
        ModuleDeployPathControllerTest.assertEquals((String)expected, (String)depDir);
    }

    public void testGettersNoPrefsWarInEar() {
        String initialDeployDir = "/home/user/tmp";
        String initialTmpDeployDir = "/home/user/tmp2";
        IModuleDeployPathController contr = this.buildEnv(initialDeployDir, initialTmpDeployDir, null);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule ear = MockModuleUtil.createMockEarModule();
        String earWithSuffix = String.valueOf(ear.getName()) + ".ear";
        String warWithSuffix = String.valueOf(web.getName()) + ".war";
        String uri = "nested/inside/" + warWithSuffix;
        ear.addChildModule(web, uri);
        IModule[] webInEar = new IModule[]{ear, web};
        String tmpDir = contr.getTemporaryDeployDirectory(webInEar).toOSString();
        ModuleDeployPathControllerTest.assertEquals((String)tmpDir, (String)initialTmpDeployDir);
        String depDir = contr.getDeployDirectory(webInEar).toOSString();
        String expected = String.valueOf(initialDeployDir) + "/" + earWithSuffix + "/" + uri;
        ModuleDeployPathControllerTest.assertEquals((String)expected, (String)depDir);
    }

    public void testGettersNoPrefsUtilInWar() {
        String initialDeployDir = "/home/user/tmp";
        String initialTmpDeployDir = "/home/user/tmp2";
        IModuleDeployPathController contr = this.buildEnv(initialDeployDir, initialTmpDeployDir, null);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule util = MockModuleUtil.createMockUtilModule();
        String utilWithSuffix = String.valueOf(util.getName()) + ".jar";
        String warWithSuffix = String.valueOf(web.getName()) + ".war";
        String uri = "nested/inside/" + utilWithSuffix;
        web.addChildModule(util, uri);
        IModule[] utilInWeb = new IModule[]{web, util};
        String tmpDir = contr.getTemporaryDeployDirectory(utilInWeb).toOSString();
        ModuleDeployPathControllerTest.assertEquals((String)tmpDir, (String)initialTmpDeployDir);
        String depDir = contr.getDeployDirectory(utilInWeb).toOSString();
        String expected = String.valueOf(initialDeployDir) + "/" + warWithSuffix + "/" + uri;
        ModuleDeployPathControllerTest.assertEquals((String)expected, (String)depDir);
    }

    public void testGettersNoPrefsUtilInWarInEar() {
        String initialDeployDir = "/home/user/tmp";
        String initialTmpDeployDir = "/home/user/tmp2";
        IModuleDeployPathController contr = this.buildEnv(initialDeployDir, initialTmpDeployDir, null);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        MockModule ear = MockModuleUtil.createMockEarModule();
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule util = MockModuleUtil.createMockUtilModule();
        String earWithSuffix = String.valueOf(ear.getName()) + ".ear";
        String utilWithSuffix = String.valueOf(util.getName()) + ".jar";
        String warWithSuffix = String.valueOf(web.getName()) + ".war";
        String uriWar = "warNest/" + warWithSuffix;
        String uriUtil = "util/Nest/" + utilWithSuffix;
        web.addChildModule(util, uriUtil);
        ear.addChildModule(web, uriWar);
        IModule[] utilInWebInEar = new IModule[]{ear, web, util};
        String tmpDir = contr.getTemporaryDeployDirectory(utilInWebInEar).toOSString();
        ModuleDeployPathControllerTest.assertEquals((String)tmpDir, (String)initialTmpDeployDir);
        String depDir = contr.getDeployDirectory(utilInWebInEar).toOSString();
        String expected = String.valueOf(initialDeployDir) + "/" + earWithSuffix + "/" + uriWar + "/" + uriUtil;
        ModuleDeployPathControllerTest.assertEquals((String)expected, (String)depDir);
    }

    public void testSettersFailWithoutWC() {
        String initialDeployDir = "/home/user/tmp";
        String initialTmpDeployDir = "/home/user/tmp2";
        IModuleDeployPathController contr = this.buildEnv(initialDeployDir, initialTmpDeployDir, null);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        MockModule web = MockModuleUtil.createMockWebModule();
        try {
            contr.setDeployDirectory((IModule)web, "arbitraryPath");
            ModuleDeployPathControllerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            contr.setOutputName((IModule)web, "arbitraryPath");
            ModuleDeployPathControllerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            contr.setTemporaryDeployDirectory((IModule)web, "arbitraryPath");
            ModuleDeployPathControllerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testSetDeployPathLinuxAbsolute() {
        String initial = "/home/user/deploy";
        String initialTmp = "/home/user/deployTmp";
        String propVal = "/home/user/webDeploy";
        String expectedPrefix = "/home/user/webDeploy/";
        this.setDeployPathShallow(initial, initialTmp, propVal, expectedPrefix, null);
    }

    public void testSetDeployPathLinuxRelative() {
        String initial = "/home/user/deploy";
        String initialTmp = "/home/user/deployTmp";
        String propVal = "innerForModule";
        String expectedPrefix = "/home/user/deploy/innerForModule/";
        this.setDeployPathShallow(initial, initialTmp, propVal, expectedPrefix, null);
    }

    public void testSetDeployPathWindowsAbsolute() {
        String initial = "C:\\user\\deploy";
        String initialTmp = "C:\\user\\deployTmp";
        String propVal = "C:\\user\\newDeploy";
        String expectedPrefix = "C:\\user\\newDeploy\\";
        this.setDeployPathShallow(initial, initialTmp, propVal, expectedPrefix, new Character('\\'));
    }

    public void testSetDeployPathWindowsRelative() {
        String initial = "C:\\user\\deploy";
        String initialTmp = "C:\\user\\deployTmp";
        String propVal = "innerForModule";
        String expectedPrefix = "C:\\user\\deploy\\innerForModule\\";
        this.setDeployPathShallow(initial, initialTmp, propVal, expectedPrefix, new Character('\\'));
    }

    private void setDeployPathShallow(String initial, String initialTmp, String propVal, String expectedPrefix, Character separator) {
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        IModuleDeployPathController contr = this.buildEnv(initial, initialTmp, wc, separator);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        MockModule web = MockModuleUtil.createMockWebModule();
        contr.setDeployDirectory((IModule)web, propVal);
        try {
            wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ModuleDeployPathControllerTest.fail((String)ce.getMessage());
        }
        IModuleDeployPathController contr2 = this.buildEnv(initial, initialTmp, null, separator);
        String depDir = contr2.getDeployDirectory(new IModule[]{web}).toOSString();
        ModuleDeployPathControllerTest.assertEquals((String)(String.valueOf(expectedPrefix) + web.getName() + ".war"), (String)depDir);
    }

    public void testSetTmpDeployPathLinuxAbsolute() {
        String initial = "/home/user/deploy";
        String initialTmp = "/home/user/deployTmp";
        String propVal = "/home/user/deployTmp2";
        String expectedPrefix = "/home/user/deployTmp2";
        this.setTmpDeployPathShallow(initial, initialTmp, propVal, expectedPrefix, null);
    }

    public void testSetTmpDeployPathLinuxRelative() {
        String initial = "/home/user/deploy";
        String initialTmp = "/home/user/deployTmp";
        String propVal = "innerTmp";
        String expectedPrefix = "/home/user/deployTmp/innerTmp";
        this.setTmpDeployPathShallow(initial, initialTmp, propVal, expectedPrefix, null);
    }

    public void testSetTmpDeployPathWindowsAbsolute() {
        String initial = "C:\\user\\deploy";
        String initialTmp = "C:\\user\\deployTmp";
        String propVal = "C:\\user\\newDeploy";
        String expectedPrefix = "C:\\user\\newDeploy";
        this.setTmpDeployPathShallow(initial, initialTmp, propVal, expectedPrefix, new Character('\\'));
    }

    public void testSetTmpDeployPathWindowsRelative() {
        String initial = "C:\\user\\deploy";
        String initialTmp = "C:\\user\\deployTmp";
        String propVal = "innerForModule";
        String expectedPrefix = "C:\\user\\deployTmp\\innerForModule";
        this.setTmpDeployPathShallow(initial, initialTmp, propVal, expectedPrefix, new Character('\\'));
    }

    private void setTmpDeployPathShallow(String initial, String initialTmp, String propVal, String expectedPrefix, Character separator) {
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        IModuleDeployPathController contr = this.buildEnv(initial, initialTmp, wc, separator);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        MockModule web = MockModuleUtil.createMockWebModule();
        contr.setTemporaryDeployDirectory((IModule)web, propVal);
        try {
            wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ModuleDeployPathControllerTest.fail((String)ce.getMessage());
        }
        IModuleDeployPathController contr2 = this.buildEnv(initial, initialTmp, null, separator);
        String tmpDeploy = contr2.getTemporaryDeployDirectory(new IModule[]{web}).toOSString();
        ModuleDeployPathControllerTest.assertEquals((String)expectedPrefix, (String)tmpDeploy);
    }

    public void testSetDeployPathLinuxAbsoluteDeep() {
        String initialDeployDir = "/home/user/deploy";
        String initialTmpDeployDir = "/home/user/deployTmp";
        String deployDirToSet = "/home/user/earDeploy";
        String expectedPrefix = "/home/user/earDeploy/";
        this.setDeployPathDeep(initialDeployDir, initialTmpDeployDir, deployDirToSet, expectedPrefix, null);
    }

    public void testSetDeployPathLinuxRelativeDeep() {
        String initialDeployDir = "/home/user/deploy";
        String initialTmpDeployDir = "/home/user/deployTmp";
        String deployDirToSet = "innerDeploy";
        String expectedPrefix = "/home/user/deploy/innerDeploy/";
        this.setDeployPathDeep(initialDeployDir, initialTmpDeployDir, deployDirToSet, expectedPrefix, null);
    }

    public void testSetDeployPathWindowsAbsoluteDeep() {
        String initialDeployDir = "C:\\user\\deploy";
        String initialTmpDeployDir = "C:\\user\\deployTmp";
        String deployDirToSet = "C:\\user\\earDeploy";
        String expectedPrefix = "C:\\user\\earDeploy\\";
        this.setDeployPathDeep(initialDeployDir, initialTmpDeployDir, deployDirToSet, expectedPrefix, Character.valueOf('\\'));
    }

    public void testSetDeployPathWindowsRelativeDeep() {
        String initialDeployDir = "C:\\user\\deploy";
        String initialTmpDeployDir = "C:\\user\\deploy2";
        String deployDirToSet = "innerDeploy";
        String expectedPrefix = "C:\\user\\deploy\\innerDeploy\\";
        this.setDeployPathDeep(initialDeployDir, initialTmpDeployDir, deployDirToSet, expectedPrefix, Character.valueOf('\\'));
    }

    private void setDeployPathDeep(String initialDeployDir, String initialTmpDeployDir, String deployDirToSet, String expectedPrefix, Character sep) {
        char sep2 = sep == null ? File.separatorChar : sep.charValue();
        IModuleDeployPathController contr = this.buildEnv(initialDeployDir, initialTmpDeployDir, null, sep);
        ModuleDeployPathControllerTest.assertTrue((boolean)contr.validate().isOK());
        MockModule ear = MockModuleUtil.createMockEarModule();
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule util = MockModuleUtil.createMockUtilModule();
        String earWithSuffix = String.valueOf(ear.getName()) + ".ear";
        String utilWithSuffix = String.valueOf(util.getName()) + ".jar";
        String warWithSuffix = String.valueOf(web.getName()) + ".war";
        String uriWar = "warNest" + sep2 + warWithSuffix;
        String uriUtil = "util" + sep2 + "Nest" + sep2 + utilWithSuffix;
        web.addChildModule(util, uriUtil);
        ear.addChildModule(web, uriWar);
        IModule[] utilInWebInEar = new IModule[]{ear, web, util};
        String tmpDir = contr.getTemporaryDeployDirectory(utilInWebInEar).toOSString();
        ModuleDeployPathControllerTest.assertEquals((String)tmpDir, (String)initialTmpDeployDir);
        String expected = String.valueOf(initialDeployDir) + sep2 + earWithSuffix + sep2 + uriWar + sep2 + uriUtil;
        String depDir = contr.getDeployDirectory(utilInWebInEar).toOSString();
        ModuleDeployPathControllerTest.assertEquals((String)expected, (String)depDir);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        IModuleDeployPathController contr2 = this.buildEnv(initialDeployDir, initialTmpDeployDir, wc, sep);
        contr2.setDeployDirectory((IModule)ear, deployDirToSet);
        try {
            wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ModuleDeployPathControllerTest.fail((String)ce.getMessage());
        }
        IModuleDeployPathController contr3 = this.buildEnv(initialDeployDir, initialTmpDeployDir, null, sep);
        String depDirInnerUtil = contr3.getDeployDirectory(utilInWebInEar).toOSString();
        String expectedResult = String.valueOf(expectedPrefix) + earWithSuffix + sep2 + uriWar + sep2 + uriUtil;
        ModuleDeployPathControllerTest.assertEquals((String)expectedResult, (String)depDirInnerUtil);
    }

    private IModuleDeployPathController buildEnv(String dep, String tmpDep, IServerWorkingCopy wc) {
        return this.buildEnv(dep, tmpDep, wc, null);
    }

    private IModuleDeployPathController buildEnv(String dep, String tmpDep, IServerWorkingCopy wc, Character targetSystemSeparator) {
        ServerSubsystemTest1.ModelSubclass c = new ServerSubsystemTest1.ModelSubclass();
        String serverType = "org.jboss.ide.eclipse.as.systemCopyServer";
        String system = SYSTEM;
        String subsystem = SUBSYSTEM;
        SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings(serverType, system);
        ModuleDeployPathControllerTest.assertTrue((types != null ? 1 : 0) != 0);
        ModuleDeployPathControllerTest.assertTrue((types.length == 1 ? 1 : 0) != 0);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("IModuleDeployPathController.DeployFolder", dep);
        env.put("IModuleDeployPathController.TmpDeployFolder", tmpDep);
        if (targetSystemSeparator != null) {
            env.put("PathHandling.TargetSystemSeparator", targetSystemSeparator);
        }
        try {
            IServerWorkingCopy serverToUse = wc == null ? this.server : wc;
            ISubsystemController controller = c.createSubsystemController((IServerAttributes)serverToUse, system, null, null, env);
            ModuleDeployPathControllerTest.assertNotNull((Object)controller);
            ModuleDeployPathControllerTest.assertTrue((boolean)controller.getSubsystemMappedId().equals(subsystem));
            ModuleDeployPathControllerTest.assertTrue((boolean)(controller instanceof IModuleDeployPathController));
            return (IModuleDeployPathController)controller;
        }
        catch (CoreException ce) {
            ModuleDeployPathControllerTest.fail((String)ce.getMessage());
            return null;
        }
    }

    public void testControllerFoundForAllServers() {
        String[] all = ServerParameterUtils.getAllJBossServerTypeParameters();
        ServerSubsystemTest1.ModelSubclass c = new ServerSubsystemTest1.ModelSubclass();
        String system = SYSTEM;
        String subsystem = SUBSYSTEM;
        int i = 0;
        while (i < all.length) {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings(all[i], system);
            ModuleDeployPathControllerTest.assertTrue((types != null ? 1 : 0) != 0);
            ModuleDeployPathControllerTest.assertTrue((types.length == 1 ? 1 : 0) != 0);
            ModuleDeployPathControllerTest.assertEquals((String)subsystem, (String)c.getSubsystemMappedId(types[0]));
            ++i;
        }
    }

    public void testRemotePath() {
        if (File.separatorChar == '\\') {
            return;
        }
        String normalWindowsAbsolute = "C:\\my\\folder";
        ModuleDeployPathControllerTest.assertFalse((boolean)new Path(normalWindowsAbsolute).isAbsolute());
        RemotePath RemotePathWindowsAbsolute = new RemotePath(normalWindowsAbsolute, '\\');
        ModuleDeployPathControllerTest.assertTrue((boolean)RemotePathWindowsAbsolute.isAbsolute());
        IPath postAppend = RemotePathWindowsAbsolute.append("test");
        ModuleDeployPathControllerTest.assertTrue((boolean)postAppend.isAbsolute());
        ModuleDeployPathControllerTest.assertFalse((boolean)postAppend.isRoot());
        ModuleDeployPathControllerTest.assertNotSame((Object)"C:\\my\\folder\\test", (Object)postAppend.toOSString());
        RemotePath postAppend2 = new RemotePath(postAppend.toString(), '\\');
        ModuleDeployPathControllerTest.assertEquals((String)"C:\\my\\folder\\test", (String)postAppend2.toOSString());
        Path segCount = new Path("C:\\my\\folder\\test");
        RemotePath osSegCountNoSep = new RemotePath("C:\\my\\folder\\test");
        RemotePath osSegCount = new RemotePath("C:\\my\\folder\\test", '\\');
        ModuleDeployPathControllerTest.assertEquals((int)segCount.segmentCount(), (int)1);
        ModuleDeployPathControllerTest.assertEquals((int)osSegCountNoSep.segmentCount(), (int)1);
        ModuleDeployPathControllerTest.assertEquals((int)osSegCount.segmentCount(), (int)3);
    }

    private IModule[] asArray(IModule m) {
        return new IModule[]{m};
    }
}

