/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.web.deployables.WebDeployableArtifactUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.WebResource;
import org.jboss.ide.eclipse.as.core.server.internal.JBossLaunchAdapter;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WebDeployableArtifactUtilDefectTest
extends TestCase {
    private String serverType;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> options = new ArrayList<Object[]>();
        Collection<Object[]> all = ServerParameterUtils.asCollection(ServerParameterUtils.getAllJBossServerTypeParamterers());
        options.addAll(all);
        options.add(new Object[1]);
        return options;
    }

    public WebDeployableArtifactUtilDefectTest(String serverType) {
        this.serverType = serverType;
    }

    @Test
    public void testWebDeployableDefectWorkaround() throws Exception {
        IFile f = this.createProjectAndGetJavaIFile();
        if (this.serverType == null) {
            this.testWebDeployableDefect((IResource)f);
        } else {
            this.webDeployableDefectWorkaroundForServer((IResource)f);
        }
    }

    private void testWebDeployableDefect(IResource f) throws Exception {
        new WebDeployableArtifactUtil();
        IModuleArtifact artifact = WebDeployableArtifactUtil.getModuleObject((Object)f);
        if (artifact != null && artifact instanceof WebResource) {
            WebDeployableArtifactUtilDefectTest.assertFalse((boolean)((WebResource)artifact).getPath().lastSegment().endsWith(".java"));
        }
    }

    private void webDeployableDefectWorkaroundForServer(IResource f) throws Exception {
        IServer server = ServerCreationTestUtils.createServerWithRuntime(this.serverType, this.serverType);
        JBossLaunchAdapter adapter = new JBossLaunchAdapter();
        new WebDeployableArtifactUtil();
        IModuleArtifact artifact = WebDeployableArtifactUtil.getModuleObject((Object)f);
        if (artifact != null) {
            Object o = adapter.getLaunchable(server, artifact);
            WebDeployableArtifactUtilDefectTest.assertTrue((boolean)(o instanceof JBossLaunchAdapter.JBTCustomHttpLaunchable));
            URL url = ((JBossLaunchAdapter.JBTCustomHttpLaunchable)o).getURL();
            WebDeployableArtifactUtilDefectTest.assertTrue((url != null ? 1 : 0) != 0);
            String u2 = url.toString();
            WebDeployableArtifactUtilDefectTest.assertFalse((boolean)u2.endsWith(".java"));
        }
    }

    private IFile createProjectAndGetJavaIFile() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getWebDataModel("TestWeb", null, null, null, null, JavaEEFacetConstants.WEB_25, true);
        OperationTestCase.runAndVerify(dm);
        final IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("TestWeb");
        WebDeployableArtifactUtilDefectTest.assertTrue((boolean)p.exists());
        final IFile[] file = new IFile[]{null};
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file[0] = ResourceUtils.createJavaType(p, (IPath)new Path("src/my/pack"), "my.pack", "Tiger");
                WebDeployableArtifactUtilDefectTest.assertTrue((boolean)file[0].exists());
                p.build(6, (IProgressMonitor)new NullProgressMonitor());
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        return file[0];
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }
}

