/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.io.File;
import java.util.Collection;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.as.test.core.TestConstants;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ServerHomeTest
extends Assert {
    private String serverType;

    public ServerHomeTest(String serverType) {
        this.serverType = serverType;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParamterers());
    }

    @Test
    public void testServerHomeSet() {
        boolean exists;
        String loc;
        ServerHomeTest.assertNotNull((Object)this.serverType);
        IServerType type = ServerCore.findServerType((String)this.serverType);
        if (type == null) {
            ServerHomeTest.fail((String)("Server type " + type + " not found in the build"));
        }
        if (type.getRuntimeType() == null) {
            ServerHomeTest.fail((String)("Server type " + this.serverType + " does not have an associated runtime"));
        }
        if ((loc = TestConstants.getServerHome(this.serverType)) == null) {
            ServerHomeTest.fail((String)("Test Runtime for " + this.serverType + " is not set properly in the build"));
        }
        if (!(exists = new File(loc).exists())) {
            ServerHomeTest.fail((String)(String.valueOf(this.serverType) + " (" + loc + ") does not exist."));
        }
    }
}

