/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ProjectRuntimeUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Ear50CreationTest
extends Assert {
    private static String PROJECT_PREFIX = "a1Ear";
    private static int PROJECT_ID = 1;
    private String serverType;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParamterers());
    }

    public Ear50CreationTest(String serverType) {
        this.serverType = serverType;
    }

    @Test
    public void testApplicationXML() throws Exception {
        String projectName = String.valueOf(PROJECT_PREFIX) + PROJECT_ID;
        IServer server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, "server" + PROJECT_ID);
        ++PROJECT_ID;
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel(projectName, "contentDirS", null, null, JavaEEFacetConstants.EAR_5, false);
        dm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)RuntimeManager.getRuntime((String)server.getRuntime().getId()));
        OperationTestCase.runAndVerify(dm);
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("newModule");
        Ear50CreationTest.assertTrue((boolean)p.exists());
        Ear50CreationTest.assertNotNull((Object)ProjectRuntimeUtil.getRuntime(p));
        IFile f = p.getFile(new Path("contentDirS").append("META-INF").append("application.xml"));
        Ear50CreationTest.assertEquals((Object)this.shouldExist(server), (Object)f.exists());
    }

    private boolean shouldExist(IServer server) {
        String typeId = server.getServerType().getId();
        if ("org.jboss.ide.eclipse.as.32".equals(typeId)) {
            return true;
        }
        if ("org.jboss.ide.eclipse.as.40".equals(typeId)) {
            return true;
        }
        return "org.jboss.ide.eclipse.as.42".equals(typeId);
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }
}

