/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CreateRuntimeTwiceTest
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getAllJBossServerTypeParamterers());
    }

    public CreateRuntimeTwiceTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void createRuntimes() throws CoreException {
        IServerType type = ServerCore.findServerType((String)this.serverType);
        IRuntimeType runtimeType = type.getRuntimeType();
        IRuntimeWorkingCopy firstRuntime = runtimeType.createRuntime(null, (IProgressMonitor)new NullProgressMonitor());
        IRuntime savedRuntime = firstRuntime.save(true, (IProgressMonitor)new NullProgressMonitor());
        IRuntimeWorkingCopy secondRuntime = runtimeType.createRuntime(null, (IProgressMonitor)new NullProgressMonitor());
        IRuntime secondSavedRuntime = secondRuntime.save(true, (IProgressMonitor)new NullProgressMonitor());
        CreateRuntimeTwiceTest.assertNotSame((Object)savedRuntime.getName(), (Object)secondSavedRuntime.getName());
        CreateRuntimeTwiceTest.assertNotSame((Object)savedRuntime, (Object)secondSavedRuntime);
        CreateRuntimeTwiceTest.assertFalse((String)("Why are two different runtimes " + runtimeType.getId() + " created with the same ID ?!"), (boolean)savedRuntime.getId().equals(secondSavedRuntime.getId()));
    }
}

