/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.internal.command.CommandExec;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GFPropertySection
extends AbstractPropertySection
implements PropertyChangeListener {
    protected PictogramElement getSelectedPictogramElement() {
        if (this.getSelection() instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)this.getSelection();
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof PictogramElement) {
                return (PictogramElement)firstElement;
            }
            EditPart editPart = null;
            if (firstElement instanceof EditPart) {
                editPart = (EditPart)firstElement;
            } else if (firstElement instanceof IAdaptable) {
                editPart = (EditPart)((IAdaptable)firstElement).getAdapter(EditPart.class);
            }
            if (editPart != null && editPart.getModel() instanceof PictogramElement) {
                return (PictogramElement)editPart.getModel();
            }
        }
        return null;
    }

    public void execute(IFeature feature, IContext context) {
        try {
            CommandExec.executeFeatureWithContext((IFeature)feature, (IContext)context);
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                T.racer().log(1, "GFCommandStack.execute(Command) " + e, e);
            }
            T.racer().error("GFCommandStack.execute(Command) " + e, e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    protected IDiagramEditor getDiagramEditor() {
        IWorkbenchPart part = this.getPart();
        IDiagramEditor ret = this.checkAdapter((IAdaptable)part, IDiagramEditor.class);
        if (ret != null) {
            return ret;
        }
        IContributedContentsView contributedView = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        if (contributedView != null) {
            part = contributedView.getContributingPart();
        }
        ret = this.checkAdapter((IAdaptable)part, IDiagramEditor.class);
        return ret;
    }

    private <U> U checkAdapter(IAdaptable adaptable, Class<U> clazz) {
        if (clazz.isInstance(adaptable)) {
            return (U)adaptable;
        }
        return (U)adaptable.getAdapter(clazz);
    }

    protected IDiagramContainer getDiagramContainer() {
        IWorkbenchPart part = this.getPart();
        IDiagramContainer ret = this.checkAdapter((IAdaptable)part, IDiagramContainer.class);
        if (ret != null) {
            return ret;
        }
        IContributedContentsView contributedView = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        if (contributedView != null) {
            part = contributedView.getContributingPart();
        }
        ret = this.checkAdapter((IAdaptable)part, IDiagramContainer.class);
        return ret;
    }

    protected Diagram getDiagram() {
        IDiagramTypeProvider diagramTypeProvider = this.getDiagramTypeProvider();
        if (diagramTypeProvider == null) {
            return null;
        }
        return diagramTypeProvider.getDiagram();
    }

    protected IDiagramTypeProvider getDiagramTypeProvider() {
        IDiagramContainer diagramContainer = this.getDiagramContainer();
        if (diagramContainer == null) {
            return null;
        }
        return diagramContainer.getDiagramTypeProvider();
    }
}

