/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFColorConstants;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class Tooltip
extends FlowPage {
    private static final int TOOLTIP_MAX_WIDTH = 250;
    private static final Border TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 2);
    private static Font boldFont;
    private TextFlow header;
    private TextFlow description;
    private String headerText;
    private String descriptionText;

    public Tooltip() {
        this.setForegroundColor(GFColorConstants.TOOLTIP_FG);
        this.setBackgroundColor(GFColorConstants.TOOLTIP_BG);
        this.setOpaque(true);
        this.setBorder(TOOLTIP_BORDER);
        this.header = new TextFlow();
        this.header.setForegroundColor(ColorConstants.darkGray);
        this.header.setFont(this.getBoldFont());
        this.add((IFigure)this.header);
        this.description = new TextFlow();
        this.description.setForegroundColor(ColorConstants.darkGray);
        this.add((IFigure)this.description);
    }

    public void setHeader(String text) {
        this.headerText = text;
        this.adjustTexts();
    }

    public void setDescription(String text) {
        this.descriptionText = text;
        this.adjustTexts();
    }

    private void adjustTexts() {
        this.description.setText(this.descriptionText);
        if (this.headerText != null && this.descriptionText != null) {
            this.header.setText(String.valueOf(this.headerText) + "\n");
        } else {
            this.header.setText(this.headerText);
        }
    }

    public Dimension getPreferredSize(int w, int h) {
        Dimension d = super.getPreferredSize(-1, -1);
        if (d.width > 250) {
            d = super.getPreferredSize(250, -1);
        }
        return d;
    }

    public void dispose() {
        if (boldFont != null) {
            boldFont.dispose();
            boldFont = null;
        }
    }

    private Font getBoldFont() {
        if (boldFont == null) {
            FontData fd = Display.getDefault().getSystemFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            boldFont = new Font((Device)Display.getDefault(), fd);
        }
        return boldFont;
    }
}

