/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.internal.features.context.impl.base.PictogramElementContext;
import org.eclipse.graphiti.mm.pictograms.AdvancedAnchor;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.parts.IAnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.parts.PictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFChopboxAnchor;
import org.eclipse.graphiti.ui.internal.util.gef.MultiCreationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedAnchorEditPart
extends AbstractGraphicalEditPart
implements IAnchorEditPart,
NodeEditPart {
    private ConnectionAnchor connectionAnchor;
    protected IPictogramElementDelegate delegate;

    public AdvancedAnchorEditPart(IConfigurationProviderInternal configurationProvider, AdvancedAnchor anchor) {
        this.setModel(anchor);
        this.delegate = new PictogramElementDelegate(configurationProvider, (PictogramElement)anchor, (EditPart)this);
    }

    public void activate() {
        super.activate();
        this.delegate.activate();
    }

    protected IFigure createFigure() {
        IFigure figure = this.delegate.createFigure();
        this.connectionAnchor = this.getModel() instanceof AdvancedAnchor ? new GFChopboxAnchor(figure, (AdvancedAnchor)this.getModel()) : new GFChopboxAnchor(figure);
        return figure;
    }

    public void deactivate() {
        this.delegate.deactivate();
        super.deactivate();
    }

    @Override
    public IConfigurationProviderInternal getConfigurationProvider() throws IllegalStateException {
        return this.delegate.getConfigurationProvider();
    }

    @Override
    public List<Connection> getModelSourceConnections() {
        Anchor anchor = (Anchor)this.getModel();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (anchor != null) {
            connections.addAll((Collection<Connection>)anchor.getOutgoingConnections());
        }
        return connections;
    }

    @Override
    public List<Connection> getModelTargetConnections() {
        Anchor anchor = (Anchor)this.getModel();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (anchor != null) {
            connections.addAll((Collection<Connection>)anchor.getIncomingConnections());
        }
        return connections;
    }

    @Override
    public PictogramElement getPictogramElement() {
        return this.delegate.getPictogramElement();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.connectionAnchor;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.delegate.refreshFigureForEditPart();
        this.getFigure().setVisible(this.getPictogramElement().isVisible());
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.delegate.refreshEditPartsForModelChildrenAndSourceConnections((EditPart)this);
    }

    @Override
    public List<PictogramElement> getModelChildren() {
        return new ArrayList<PictogramElement>();
    }

    public Object getAdapter(Class key) {
        Object ret = this.delegate.getAdapter(key);
        if (ret == null) {
            ret = super.getAdapter(key);
        }
        return ret;
    }

    public IFeatureProvider getFeatureProvider() {
        IFeatureProvider ret = null;
        if (this.delegate != null) {
            ret = this.delegate.getFeatureProvider();
        }
        return ret;
    }

    @Override
    public IPictogramElementDelegate getPictogramElementDelegate() {
        return this.delegate;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createModelObjectDeleteEditPolicy(this.getConfigurationProvider()));
        this.installEditPolicy("GraphicalNodeEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionEditPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        PictogramElementContext context = new PictogramElementContext(this.getPictogramElement());
        IFeature[] dragAndDropFeatures = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider().getDragAndDropFeatures((IPictogramElementContext)context);
        if (dragAndDropFeatures == null || dragAndDropFeatures.length == 0) {
            return super.getDragTracker(request);
        }
        ConnectionDragCreationTool tool = new ConnectionDragCreationTool(){

            protected boolean handleCreateConnection() {
                Command endCommand = this.getCommand();
                this.setCurrentCommand(endCommand);
                this.executeCurrentCommand();
                this.eraseSourceFeedback();
                return true;
            }
        };
        tool.setFactory((CreationFactory)new MultiCreationFactory(Arrays.asList(dragAndDropFeatures)));
        return tool;
    }
}

