/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.ui.internal.figures.GFAbstractShape;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.swt.graphics.Path;

public class GFRoundedRectangle
extends GFAbstractShape {
    protected Dimension corner = new Dimension(8, 8);

    public GFRoundedRectangle(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        super(pictogramElementDelegate, graphicsAlgorithm);
    }

    public void setCornerDimensions(Dimension cornerDimensions) {
        this.corner.width = cornerDimensions.width;
        this.corner.height = cornerDimensions.height;
    }

    protected Path createPath(Rectangle outerBounds, Graphics graphics, boolean isFill) {
        Path path = new Path(null);
        float x = outerBounds.x;
        float y = outerBounds.y;
        float height = outerBounds.height;
        float width = outerBounds.width;
        float bottom = y + height;
        float right = x + width;
        double zoom = this.getZoomLevel(graphics);
        int lineWidth = this.getLineWidth(graphics);
        float cornerWidth = (float)((double)this.corner.width * zoom);
        float cornerHeight = (float)((double)this.corner.height * zoom);
        cornerWidth = cornerWidth > width ? width : cornerWidth;
        float f = cornerHeight = cornerHeight > height ? height : cornerHeight;
        if (isFill) {
            cornerHeight = Math.max(1.0f, cornerHeight - ((float)lineWidth + cornerHeight / 64.0f));
            cornerWidth = Math.max(1.0f, cornerWidth - ((float)lineWidth + cornerWidth / 64.0f));
        }
        if (cornerHeight <= 0.0f || cornerWidth <= 0.0f) {
            path.addRectangle(x, y, width, height);
        } else {
            path.moveTo(x, y);
            path.addArc(x, y, cornerWidth, cornerHeight, 90.0f, 90.0f);
            path.addArc(x, bottom - cornerHeight, cornerWidth, cornerHeight, 180.0f, 90.0f);
            path.addArc(right - cornerWidth, bottom - cornerHeight, cornerWidth, cornerHeight, 270.0f, 90.0f);
            path.addArc(right - cornerWidth, y, cornerWidth, cornerHeight, 0.0f, 90.0f);
            path.close();
        }
        return path;
    }
}

