/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.ui.internal.figures.BezierPoint;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.figures.GFPolyline;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.swt.graphics.Path;

public class GFPolygon
extends GFPolyline {
    public GFPolygon(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        super(pictogramElementDelegate, graphicsAlgorithm);
        this.setSuppressFilling(false);
    }

    public boolean containsPointInFigure(int x, int y) {
        Boolean inFigure = GFFigureUtil.containsPointInPolygon(this.getPoints(), x, y);
        if (inFigure != null) {
            return inFigure;
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((IFigure)children.get(i)).containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Path createPath(Rectangle outerBoundss, Graphics graphics, boolean isFill) {
        double zoom = this.getZoomLevel(graphics);
        double lw = this.getLineWidth(graphics);
        PointList points = this.getAdjustedPointList(this.getPoints(), zoom, lw);
        List<BezierPoint> bezierPoints = this.getBezierPoints(points, zoom);
        boolean isClosed = true;
        Path path = GFFigureUtil.getBezierPath(bezierPoints, isClosed);
        return path;
    }
}

