/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMultiDeleteInfo;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.MultiDeleteInfo;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.action.AbstractPreDefinedAction;
import org.eclipse.graphiti.ui.internal.action.IContextAndFeatureProvider;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class DeleteAction
extends AbstractPreDefinedAction
implements IContextAndFeatureProvider {
    private static final String TOOL_TIP = Messages.DeleteAction_0_xmsg;
    private static final String TEXT = Messages.DeleteAction_1_xfld;
    public static final String ACTION_ID = ActionFactory.DELETE.getId();
    private IMultiDeleteInfo multiDeleteInfo = null;

    public DeleteAction(IWorkbenchPart part, IConfigurationProvider configurationProvider) {
        super(part, configurationProvider);
        this.setId(ACTION_ID);
        this.setText(TEXT);
        this.setToolTipText(TOOL_TIP);
    }

    public boolean isAvailable() {
        PictogramElement[] pe = this.getSelectedPictogramElements();
        int i = 0;
        while (i < pe.length) {
            DeleteContext context = new DeleteContext(pe[i]);
            IDeleteFeature deleteFeature = this.getFeatureProvider().getDeleteFeature((IDeleteContext)context);
            if (deleteFeature == null || !deleteFeature.isAvailable((IContext)context)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean calculateEnabled() {
        PictogramElement[] pe = this.getSelectedPictogramElements();
        if (pe.length == 0) {
            return false;
        }
        int i = 0;
        while (i < pe.length) {
            DeleteContext context = new DeleteContext(pe[i]);
            IFeatureProvider featureProvider = this.getFeatureProvider();
            if (featureProvider == null) {
                return false;
            }
            IDeleteFeature deleteFeature = featureProvider.getDeleteFeature((IDeleteContext)context);
            if (!(deleteFeature == null || deleteFeature.isAvailable((IContext)context) && deleteFeature.canDelete((IDeleteContext)context))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        int number = this.getSelectedPictogramElements().length;
        if (number > 1) {
            this.setMultiDeleteInfo((IMultiDeleteInfo)new MultiDeleteInfo(true, false, number));
        } else {
            this.setMultiDeleteInfo(null);
        }
        this.genericRun(this);
    }

    public IContext createContext(PictogramElement pe) {
        DeleteContext deleteContext = new DeleteContext(pe);
        if (this.getMultiDeleteInfo() != null) {
            deleteContext.setMultiDeleteInfo(this.getMultiDeleteInfo());
        }
        return deleteContext;
    }

    public IFeature provideFeatureForContext(IContext context) {
        return this.getFeatureProvider().getDeleteFeature((IDeleteContext)context);
    }

    private IMultiDeleteInfo getMultiDeleteInfo() {
        return this.multiDeleteInfo;
    }

    private void setMultiDeleteInfo(IMultiDeleteInfo multiDeleteInfo) {
        this.multiDeleteInfo = multiDeleteInfo;
    }
}

