/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.features;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDrillDownFeature
extends AbstractCustomFeature {
    private static final String NAME = Messages.AbstractDrillDownFeature_0_xfld;

    public AbstractDrillDownFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return NAME;
    }

    public void execute(ICustomContext context) {
        PictogramElement pe = context.getPictogramElements()[0];
        final Collection<Diagram> possibleDiagramsList = this.getLinkedDiagrams(pe);
        Diagram diagram = null;
        if (!possibleDiagramsList.isEmpty()) {
            Diagram[] possibleDiagrams = possibleDiagramsList.toArray(new Diagram[0]);
            if (possibleDiagramsList.size() == 1) {
                diagram = possibleDiagrams[0];
            } else {
                ListDialog dialog = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.setContentProvider(new IStructuredContentProvider(){

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }

                    public void dispose() {
                    }

                    public Object[] getElements(Object inputElement) {
                        return possibleDiagramsList.toArray();
                    }
                });
                dialog.setTitle(Messages.AbstractDrillDownFeature_1_xmsg);
                dialog.setMessage(Messages.AbstractDrillDownFeature_2_xmsg);
                dialog.setInitialSelections((Object[])new Diagram[]{possibleDiagrams[0]});
                dialog.setLabelProvider((ILabelProvider)new DiagramLabelProvider());
                dialog.setAddCancelButton(true);
                dialog.setHelpAvailable(false);
                dialog.setInput(new Object());
                dialog.open();
                Object[] result = dialog.getResult();
                if (result != null) {
                    int i = 0;
                    while (i < result.length) {
                        diagram = (Diagram)result[i];
                        ++i;
                    }
                }
            }
            if (diagram != null) {
                this.openDiagramEditor(diagram);
            }
        }
    }

    protected void openDiagramEditor(Diagram diagram) {
        String diagramTypeProviderId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        GraphitiUiInternal.getWorkbenchService().openDiagramEditor(diagram, diagramTypeProviderId, this.getDiagramEditorId(diagram));
    }

    protected String getDiagramEditorId(Diagram diagram) {
        return "org.eclipse.graphiti.ui.editor.DiagramEditor";
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = context.getPictogramElements()[0];
            Collection<Diagram> possibleDiagramsList = this.getLinkedDiagrams(pe);
            return possibleDiagramsList.size() >= 1;
        }
        return false;
    }

    public boolean hasDoneChanges() {
        return false;
    }

    protected Collection<Diagram> getLinkedDiagrams(PictogramElement pe) {
        HashSet<Diagram> ret = new HashSet<Diagram>();
        Object[] businessObjectsForPictogramElement = this.getAllBusinessObjectsForPictogramElement(pe);
        Collection<Diagram> allDiagrams = this.getDiagrams();
        for (Diagram d : allDiagrams) {
            Diagram currentDiagram = this.getDiagram();
            if (EcoreUtil.equals((EObject)currentDiagram, (EObject)d)) continue;
            Object[] businessObjectsForDiagram = this.getAllBusinessObjectsForPictogramElement((PictogramElement)d);
            int i = 0;
            while (i < businessObjectsForDiagram.length) {
                Object diagramBo = businessObjectsForDiagram[i];
                int j = 0;
                while (j < businessObjectsForPictogramElement.length) {
                    Object currentBo = businessObjectsForPictogramElement[j];
                    if (this.getFeatureProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider().equalsBusinessObjects(currentBo, diagramBo)) {
                        ret.add(d);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return ret;
    }

    protected abstract Collection<Diagram> getDiagrams();

    protected TransactionalEditingDomain getTransActionalEditingDomainForNewDiagram() {
        return GraphitiUi.getEmfService().createResourceSetAndEditingDomain();
    }

    private class DiagramLabelProvider
    extends LabelProvider {
        Image image;

        public String getText(Object o) {
            String ret = null;
            if (o instanceof Diagram) {
                Diagram diagram = (Diagram)o;
                ret = String.valueOf(diagram.getName()) + " (" + diagram.getDiagramTypeId() + ")";
            }
            return ret;
        }

        public Image getImage(Object element) {
            if (this.image == null) {
                this.image = GraphitiUi.getImageService().getPlatformImageForId("org.eclipse.graphiti.diagram");
            }
            return this.image;
        }
    }
}

