/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.el.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.refactoring.FileChangeFactory;
import org.jboss.tools.common.util.BeanUtil;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jst.web.kb.refactoring.ELProjectSetExtension;
import org.jboss.tools.jst.web.kb.refactoring.IProjectsSet;
import org.jboss.tools.jst.web.kb.refactoring.RefactorSearcher;

public class RenameMethodParticipant
extends RenameParticipant
implements ISharableParticipant {
    private IJavaElement element;
    private String oldName;
    private String newName;
    private RenameMethodSearcher searcher;
    private RefactoringStatus status;
    private CompositeChange rootChange;
    private TextFileChange lastChange;
    private ArrayList<String> keys = new ArrayList();
    private ArrayList<Object> otherElements = new ArrayList();

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.searcher == null) {
            return this.status;
        }
        if (this.element instanceof IMethod) {
            IMethod method = (IMethod)this.element;
            IMethod anotherMethod = this.getAnotherMethod();
            if (method != null) {
                if (BeanUtil.isGetter((IMethod)method)) {
                    if (anotherMethod == null || BeanUtil.isGetter((IMethod)anotherMethod)) {
                        this.status.addWarning(JsfUIMessages.RENAME_METHOD_PARTICIPANT_GETTER_WARNING);
                    }
                } else if (BeanUtil.isSetter((IMethod)method) && (anotherMethod == null || BeanUtil.isSetter((IMethod)anotherMethod))) {
                    this.status.addWarning(JsfUIMessages.RENAME_METHOD_PARTICIPANT_SETTER_WARNING);
                }
                this.searcher.findELReferences(pm);
            }
        }
        return this.status;
    }

    private IMethod getAnotherMethod() {
        for (Object object : this.otherElements) {
            if (!(object instanceof IMethod)) continue;
            return (IMethod)object;
        }
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.rootChange.getChildren().length > 0) {
            return this.rootChange;
        }
        return null;
    }

    public String getName() {
        return this.oldName;
    }

    protected boolean initialize(Object element) {
        if (!this.getArguments().getUpdateReferences()) {
            return false;
        }
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            this.status = new RefactoringStatus();
            this.rootChange = new CompositeChange(JsfUIMessages.RENAME_METHOD_PARTICIPANT_UPDATE_METHOD_REFERENCES);
            this.element = method;
            this.oldName = method.getElementName();
            this.newName = RefactorSearcher.getPropertyName((IMethod)method, (String)this.getArguments().getNewName());
            this.searcher = new RenameMethodSearcher((IFile)method.getResource(), this.oldName);
            return true;
        }
        return false;
    }

    public boolean initialize(Object element, String newName) {
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            this.status = new RefactoringStatus();
            this.rootChange = new CompositeChange(JsfUIMessages.RENAME_METHOD_PARTICIPANT_UPDATE_METHOD_REFERENCES);
            this.element = method;
            this.oldName = method.getElementName();
            this.newName = newName;
            this.searcher = new RenameMethodSearcher((IFile)method.getResource(), this.oldName);
            return true;
        }
        return false;
    }

    protected TextFileChange getChange(IFile file) {
        if (this.lastChange != null && this.lastChange.getFile().equals((Object)file)) {
            return this.lastChange;
        }
        int i = 0;
        while (i < this.rootChange.getChildren().length) {
            TextFileChange change = (TextFileChange)this.rootChange.getChildren()[i];
            if (change.getFile().equals((Object)file)) {
                this.lastChange = change;
                return this.lastChange;
            }
            ++i;
        }
        this.lastChange = FileChangeFactory.getFileChange((IFile)file);
        MultiTextEdit root = new MultiTextEdit();
        this.lastChange.setEdit((TextEdit)root);
        this.rootChange.add((Change)this.lastChange);
        return this.lastChange;
    }

    private void change(IFile file, int offset, int length, String text) {
        String key = String.valueOf(file.getFullPath().toString()) + " " + offset;
        if (!this.keys.contains(key)) {
            TextFileChange change = this.getChange(file);
            ReplaceEdit edit = new ReplaceEdit(offset, length, text);
            change.addEdit((TextEdit)edit);
            this.keys.add(key);
        }
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        this.otherElements.add(element);
    }

    class RenameMethodSearcher
    extends RefactorSearcher {
        IProjectsSet projectSet;

        public RenameMethodSearcher(IFile file, String name) {
            super(file, name, RenameMethodParticipant.this.element);
            this.projectSet = null;
            ELProjectSetExtension[] extensions = ELProjectSetExtension.getInstances();
            if (extensions.length > 0) {
                this.projectSet = extensions[0].getProjectSet();
                if (this.projectSet != null) {
                    this.projectSet.init(file.getProject());
                }
            }
        }

        protected void outOfSynch(IResource resource) {
            Exception exception = new Exception(NLS.bind((String)JsfUIMessages.RENAME_METHOD_PARTICIPANT_OUT_OF_SYNC_PROJECT, (Object)resource.getFullPath().toString()));
            exception.setStackTrace(Thread.currentThread().getStackTrace());
            JsfUiPlugin.getDefault().logError(exception);
        }

        protected void match(IFile file, int offset, int length) {
            if (this.isFileReadOnly(file)) {
                Exception exception = new Exception(NLS.bind((String)JsfUIMessages.RENAME_METHOD_PARTICIPANT_ERROR_READ_ONLY_FILE, (Object)file.getFullPath().toString()));
                exception.setStackTrace(Thread.currentThread().getStackTrace());
                JsfUiPlugin.getDefault().logError(exception);
            } else {
                RenameMethodParticipant.this.change(file, offset, length, RenameMethodParticipant.this.newName);
            }
        }

        protected IProject[] getProjects() {
            if (this.projectSet != null) {
                return this.projectSet.getLinkedProjects();
            }
            return new IProject[]{this.baseFile.getProject()};
        }

        protected IContainer getViewFolder(IProject project) {
            if (this.projectSet != null) {
                return this.projectSet.getViewFolder(project);
            }
            return super.getViewFolder(project);
        }
    }
}

