/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.model.impl;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IGroupListener;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.IJSFElementList;
import org.jboss.tools.jsf.ui.editor.model.IJSFElementListListener;
import org.jboss.tools.jsf.ui.editor.model.IJSFModel;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.model.IPage;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElement;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElementList;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFModel;
import org.jboss.tools.jsf.ui.editor.model.impl.Page;

public class Group
extends JSFElement
implements IGroup,
IJSFElementListListener {
    public static final Color DEFAULT_FOREGROUND_COLOR = new Color(null, 0, 0, 0);
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(null, 228, 228, 228);
    public static String TYPE_PROPERTY = "type";
    public static String SUBTYPE_PROPERTY = "subtype";
    public static String COMMENT_PROPERTY = "comment";
    protected Color headerForegroundColor = DEFAULT_FOREGROUND_COLOR;
    protected Color headerBackgroundColor = DEFAULT_BACKGROUND_COLOR;
    String type;
    protected Image icon = null;
    public PageList pageList;
    List<IGroupListener> groupListeners = new Vector<IGroupListener>();
    List<ILink> inputLinks = new Vector<ILink>();
    List<ILink> outputLinks = new Vector<ILink>();
    boolean selected = false;

    @Override
    public void dispose() {
        super.dispose();
        if (this.groupListeners != null) {
            this.groupListeners.clear();
        }
        this.groupListeners = null;
        if (this.inputLinks != null) {
            this.inputLinks.clear();
        }
        this.inputLinks = null;
        if (this.outputLinks != null) {
            this.outputLinks.clear();
        }
        this.outputLinks = null;
    }

    @Override
    public void addInputLink(ILink link) {
        if (!this.inputLinks.contains(link)) {
            this.inputLinks.add(link);
        }
    }

    @Override
    public void removeInputLink(ILink link) {
        this.inputLinks.remove(link);
    }

    @Override
    public void addOutputLink(ILink link, int index) {
        if (!this.outputLinks.contains(link)) {
            this.outputLinks.add(index, link);
        }
    }

    @Override
    public void addOutputLink(ILink link) {
        this.outputLinks.add(link);
    }

    @Override
    public void removeOutputLink(ILink link) {
        this.outputLinks.remove(link);
    }

    public Group(IJSFModel model, XModelObject groupNode) {
        super(model, groupNode);
        this.type = groupNode.getAttributeValue(TYPE_PROPERTY);
        this.global = false;
        this.icon = EclipseResourceUtil.getImage((XModelObject)groupNode);
        if (this.type != null) {
            this.pageList = new PageList(groupNode);
            this.pageList.addJSFElementListListener(this);
        }
    }

    @Override
    public Image getImage() {
        return EclipseResourceUtil.getImage((XModelObject)this.source);
    }

    public Group(IJSFModel model, IJSFElement element) {
        super(model);
    }

    @Override
    public String getViewClassName() {
        return "";
    }

    @Override
    public String getVisiblePath() {
        return this.getJSFModel().getHelper().getPageTitle(this.source);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public boolean isPage() {
        return true;
    }

    @Override
    public boolean isComment() {
        return false;
    }

    @Override
    public void setSelected(boolean set) {
        boolean oldValue = this.selected;
        this.selected = set;
        this.propertyChangeSupport.firePropertyChange("selected", oldValue, set);
        if (set) {
            this.getJSFModel().setSelectedProcessItem(this);
        }
    }

    @Override
    public void clearSelection() {
        IJSFElementList list = this.getJSFModel().getGroupList();
        int i = 0;
        while (i < list.size()) {
            IGroup activity = (IGroup)list.get(i);
            activity.setSelected(false);
            ++i;
        }
    }

    @Override
    public boolean hasPageHiddenLinks() {
        if (this.getSource() != null) {
            return this.getJSFModel().getHelper().hasPageHiddenLinks((XModelObject)this.getSource());
        }
        return false;
    }

    @Override
    public IGroup getCommentTarget() {
        return null;
    }

    @Override
    public boolean isConfirmed() {
        if (this.getSource() != null) {
            return !this.getJSFModel().getHelper().isUnconfirmedPage((XModelObject)this.getSource());
        }
        return false;
    }

    @Override
    public boolean isPattern() {
        if (this.getSource() != null) {
            return this.getJSFModel().getHelper().isGroupPattern((XModelObject)this.getSource());
        }
        return false;
    }

    @Override
    public boolean hasErrors() {
        return this.getJSFModel().getHelper().hasErrors((XModelObject)this.getSource());
    }

    public void setHeaderForegroundColor(Color color) {
        this.headerForegroundColor = color;
    }

    public Color getHeaderForegroundColor() {
        return this.headerForegroundColor;
    }

    public void setHeaderBackgroundColor(Color color) {
        this.headerBackgroundColor = color;
    }

    public Color getHeaderBackgroundColor() {
        return this.headerBackgroundColor;
    }

    @Override
    public ILink[] getLinks() {
        IJSFElementList pages = this.getPageList();
        ArrayList<ILink> links = new ArrayList<ILink>();
        links.addAll(this.inputLinks);
        int i = 0;
        while (i < pages.size()) {
            IJSFElementList list = ((IPage)pages.get(i)).getLinkList();
            int j = 0;
            while (j < list.size()) {
                ILink link = (ILink)list.get(j);
                if (link != null) {
                    links.add(link);
                }
                ++j;
            }
            ++i;
        }
        ILink[] trans = new ILink[links.size()];
        links.toArray(trans);
        return trans;
    }

    @Override
    public ILink[] getInputLinks() {
        return (ILink[])this.inputLinks.toArray();
    }

    @Override
    public List getListInputLinks() {
        return this.inputLinks;
    }

    @Override
    public ILink[] getOutputLinks() {
        return this.getLinks();
    }

    @Override
    public List getListOutputLinks() {
        return this.outputLinks;
    }

    @Override
    public IPage getPage(String pageName) {
        return (Page)this.pageList.get(pageName);
    }

    @Override
    public IJSFElementList getPageList() {
        return this.pageList;
    }

    public void fireGroupChange() {
        if (this.groupListeners.size() == 0) {
            return;
        }
        ArrayList<IGroupListener> targets = new ArrayList<IGroupListener>();
        targets.addAll(this.groupListeners);
        int i = 0;
        while (i < targets.size()) {
            IGroupListener listener = (IGroupListener)targets.get(i);
            if (listener != null) {
                listener.groupChange();
            }
            ++i;
        }
    }

    public void firePageAdd(IPage page) {
        ArrayList<IGroupListener> listeners = new ArrayList<IGroupListener>();
        listeners.addAll(this.groupListeners);
        int i = 0;
        while (i < listeners.size()) {
            IGroupListener listener = (IGroupListener)listeners.get(i);
            if (listener != null && listener.isGroupListenerEnable()) {
                ((IGroupListener)listeners.get(i)).pageAdd(this, page);
            }
            ++i;
        }
    }

    public void firePageRemove(IPage page, int index) {
        ArrayList<IGroupListener> listeners = new ArrayList<IGroupListener>();
        listeners.addAll(this.groupListeners);
        int i = 0;
        while (i < listeners.size()) {
            IGroupListener listener = (IGroupListener)listeners.get(i);
            if (listener != null && listener.isGroupListenerEnable()) {
                ((IGroupListener)listeners.get(i)).pageRemove(this, page);
            }
            ++i;
        }
    }

    public void firePageChange(IPage message, PropertyChangeEvent evt) {
    }

    public void fireLinkAdd(IPage page, ILink link) {
        ArrayList<IGroupListener> listeners = new ArrayList<IGroupListener>();
        listeners.addAll(this.groupListeners);
        int i = 0;
        while (i < listeners.size()) {
            IGroupListener listener = (IGroupListener)listeners.get(i);
            if (listener != null && listener.isGroupListenerEnable()) {
                ((IGroupListener)listeners.get(i)).linkAdd(page, link);
            }
            ++i;
        }
    }

    public void fireLinkRemove(IPage page, ILink link, int index) {
        ArrayList<IGroupListener> listeners = new ArrayList<IGroupListener>();
        listeners.addAll(this.groupListeners);
        int i = 0;
        while (i < listeners.size()) {
            IGroupListener listener = (IGroupListener)listeners.get(i);
            if (listener != null && listener.isGroupListenerEnable()) {
                ((IGroupListener)listeners.get(i)).linkRemove(page, link);
            }
            ++i;
        }
    }

    @Override
    public void remove() {
        int i = 0;
        while (i < this.getPageList().size()) {
            ((Page)this.getPageList().get(i)).remove();
            ++i;
        }
    }

    @Override
    public void addGroupListener(IGroupListener listener) {
        this.groupListeners.add(listener);
    }

    @Override
    public void removeGroupListener(IGroupListener listener) {
    }

    @Override
    public void removeFromJSFModel() {
    }

    @Override
    public void nodeChanged(Object eventData) {
        this.fireGroupChange();
        this.propertyChangeSupport.firePropertyChange("name", "", this.getSourceProperty("name"));
        this.propertyChangeSupport.firePropertyChange("shape", "", this.getSourceProperty("shape"));
        this.propertyChangeSupport.firePropertyChange("path", "", this.getSourceProperty("path"));
    }

    @Override
    public void structureChanged(Object eventData) {
        this.pageList.structureChanged(eventData);
    }

    @Override
    public void nodeAdded(Object eventData) {
        this.pageList.nodeAdded(eventData);
    }

    @Override
    public void nodeRemoved(Object eventData) {
        this.pageList.nodeRemoved(eventData);
    }

    @Override
    public boolean isElementListListenerEnable() {
        return true;
    }

    @Override
    public void setElementListListenerEnable(boolean set) {
    }

    @Override
    public void listElementMove(IJSFElementList list, IJSFElement element, int newIndex, int oldIndex) {
    }

    @Override
    public void listElementAdd(IJSFElementList list, IJSFElement element, int index) {
        this.firePageAdd((IPage)element);
    }

    @Override
    public void listElementRemove(IJSFElementList list, IJSFElement element, int index) {
        this.firePageRemove((IPage)element, index);
    }

    @Override
    public void listElementChange(IJSFElementList list, IJSFElement element, int index, PropertyChangeEvent event) {
    }

    public class PageList
    extends JSFElementList {
        public PageList(XModelObject listSource) {
            super(Group.this);
            XModelObject[] pages = listSource.getChildren();
            int i = 0;
            while (i < pages.length) {
                Page newPage = new Page(Group.this, pages[i]);
                this.add(newPage);
                ++i;
            }
        }

        @Override
        public void structureChanged(Object eventData) {
            XModelObject o;
            IJSFElement pe;
            XModelObject listSource = (XModelObject)Group.this.getSource();
            XModelObject[] pages = listSource.getChildren();
            if (pages.length != this.size()) {
                return;
            }
            int i = 0;
            while (i < this.size()) {
                pe = (IJSFElement)this.get(i);
                o = (XModelObject)pe.getSource();
                if (listSource.getChildByPath(o.getPathPart()) == null) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.size()) {
                pe = (IJSFElement)this.get(i);
                o = (XModelObject)pe.getSource();
                if (!pages[i].getPathPart().equals(o.getPathPart())) {
                    this.moveTo(pe, this.size() - 1);
                    --i;
                }
                ++i;
            }
        }

        @Override
        public void nodeAdded(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            Page newPage = new Page(Group.this, (XModelObject)event.getInfo());
            this.addPage(newPage);
        }

        @Override
        public void nodeRemoved(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            IPage removedPage = (IPage)this.getFromMap(event.getInfo());
            removedPage.remove();
            this.removePage(removedPage);
        }

        public void addPage(IPage page) {
            ((JSFModel)this.jsfModel).putToMap(page.getSource(), page);
            this.add(page);
            Group.this.firePageAdd(page);
        }

        public void removePage(IPage page) {
            this.removeFromMap(page);
            int index = this.indexOf(page);
            this.remove(page);
            Group.this.firePageRemove(page, index);
        }
    }
}

