/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.check;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.check.ProjectNaturesInfoDialog;
import org.jboss.tools.jsf.ui.editor.check.wizards.QuickFixWizard;

public class KBNaturesInfoDialog
extends ProjectNaturesInfoDialog {
    public KBNaturesInfoDialog(IProject project) {
        super(project, JsfUIMessages.ENABLE_JSF_CODE_COMPLETION_BUTTON_LABEL);
    }

    @Override
    protected void fixButtonPressed() {
        try {
            IMarker kbProblemMarker = null;
            IMarker[] markers = this.project.findMarkers(null, false, 1);
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                String _type = marker.getType();
                if (_type != null && _type.equals("org.jboss.tools.jst.web.kb.kbBuilderProblemMarker")) {
                    kbProblemMarker = marker;
                    break;
                }
                ++i;
            }
            if (kbProblemMarker != null) {
                LinkedHashMap resolutions = new LinkedHashMap(0);
                ArrayList<IMarker> markerList = new ArrayList<IMarker>(0);
                IMarkerResolution[] markerResolutions = IDE.getMarkerHelpRegistry().getResolutions(kbProblemMarker);
                markerList.add(kbProblemMarker);
                resolutions.put(markerResolutions[0], markerList);
                String markerDescription = kbProblemMarker.getAttribute("message", "");
                String description = NLS.bind((String)MarkerMessages.MarkerResolutionDialog_Description, (Object)markerDescription);
                QuickFixWizard fixWizard = new QuickFixWizard(description, resolutions);
                fixWizard.setWindowTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
                QuickFixWizardDialog dialog = new QuickFixWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)fixWizard);
                dialog.open();
            }
        }
        catch (CoreException e) {
            JsfUiPlugin.getDefault().logError(e);
        }
    }

    @Override
    protected String getMessageInfo() {
        String dialogMessage = MessageFormat.format(JsfUIMessages.ENABLE_JSF_CODE_COMPLETION_TEXT, this.project.getName());
        return dialogMessage;
    }

    @Override
    protected void skipButtonPressed() {
        try {
            String value = !this.isRemember ? "yes" : "no";
            Preference.SHOW_NATURE_WARNING.setValue(value);
        }
        catch (XModelException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private class QuickFixWizardDialog
    extends WizardDialog {
        public QuickFixWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
            this.setShellStyle(0xC70 | QuickFixWizardDialog.getDefaultOrientation());
        }
    }
}

