/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.convert.bpmnto.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.jbpm.convert.b2j.messages.B2JMessages;
import org.jboss.tools.jbpm.convert.bpmnto.util.BPMNToUtil;
import org.jboss.tools.jbpm.convert.bpmnto.wizard.BPMNResourcesChoicePage;
import org.jboss.tools.jbpm.convert.bpmnto.wizard.BpmnPoolsChoicePage;
import org.jboss.tools.jbpm.convert.bpmnto.wizard.ErrorMessagesPage;
import org.jboss.tools.jbpm.convert.bpmnto.wizard.GeneratedFileLocationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BpmnToWizard
extends Wizard
implements IExportWizard {
    private BPMNResourcesChoicePage bpmnResPage;
    private BpmnPoolsChoicePage poolsPage;
    private GeneratedFileLocationPage locationPage;
    private ErrorMessagesPage errorPage;
    private IStructuredSelection selection;
    private IStructuredSelection targetLocationSelection;
    private Map<String, String> idMap;
    private boolean isOverWrite = true;
    private boolean isDoTranslation = false;
    protected String bpmnFileName;
    protected String bpmnFileParentPath;
    protected List<String> poolIdList = new ArrayList<String>();
    protected List<String> errorList = new ArrayList<String>();
    protected List<String> warningList = new ArrayList<String>();

    public BpmnToWizard() {
        super.setWindowTitle(B2JMessages.Bpmn_Wizard_Title);
    }

    public void addPages() {
        super.addPages();
        this.bpmnResPage = new BPMNResourcesChoicePage(B2JMessages.Bpmn_File_Choose_WizardPage_Name, B2JMessages.Bpmn_File_Choose_WizardPage_Title, B2JMessages.Bpmn_File_Choose_WizardPage_ViewerTitle, B2JMessages.Bpmn_File_Choose_WizardPage_Message);
        this.bpmnResPage.setSelection((ISelection)this.selection);
        this.poolsPage = new BpmnPoolsChoicePage(B2JMessages.Bpmn_Pool_Choose_WizardPage_Name, B2JMessages.Bpmn_Pool_Choose_WizardPage_Title, B2JMessages.Bpmn_Pool_Choose_WizardPage_ViewerTitle, B2JMessages.Bpmn_Pool_Choose_WizardPage_Message);
        this.errorPage = new ErrorMessagesPage(B2JMessages.Bpmn_Translate_Message_WizardPage_Name, B2JMessages.Bpmn_Translate_Message_WizardPage_Title, B2JMessages.Bpmn_Translate_Message_WizardpageViewer_Title, B2JMessages.Bpmn_Translate_Message_WizardPage_Message);
        this.locationPage = new GeneratedFileLocationPage(B2JMessages.Bpmn_GeneratedFile_Location_WizardPage_Name, B2JMessages.Bpmn_GeneratedFile_Location_WizardPage_Title, B2JMessages.Bpmn_GeneratedFile_Location_WizardPage_ViewerTitle, B2JMessages.Bpmn_GeneratedFile_Location_WizardPage_Message);
        this.locationPage.setSelection((ISelection)this.selection);
        this.addPage((IWizardPage)this.bpmnResPage);
        this.addPage((IWizardPage)this.poolsPage);
        this.addPage((IWizardPage)this.errorPage);
        this.addPage((IWizardPage)this.locationPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.initialize();
    }

    private void initialize() {
        IFile bpmnFile;
        if (this.selection.getFirstElement() instanceof IFile && "bpmn".equals((bpmnFile = (IFile)this.selection.getFirstElement()).getFileExtension())) {
            this.bpmnFileName = bpmnFile.getName();
            this.bpmnFileParentPath = bpmnFile.getParent().getLocation().toOSString();
            try {
                this.idMap = BPMNToUtil.getPoolIDsFromDocument(BPMNToUtil.parse(this.bpmnFileParentPath, this.bpmnFileName));
                this.poolIdList.clear();
            }
            catch (Exception exception) {
                this.errorList.add(0, NLS.bind((String)B2JMessages.Translate_Error_File_CanNotRead, (Object)this.bpmnFileName));
            }
        }
        if (this.poolsPage != null) {
            this.poolsPage.setIdMap(this.idMap);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.getName().equals(B2JMessages.Bpmn_File_Choose_WizardPage_Name) && this.errorList.size() > 0) {
            this.errorPage.getListViewer().setInput(this.errorList);
            return this.errorPage;
        }
        if (page.getName().equals(B2JMessages.Bpmn_Pool_Choose_WizardPage_Name)) {
            this.translateBpmnToStrings();
            this.isDoTranslation = true;
            if (this.errorList.size() == 0 && this.warningList.size() == 0) {
                return this.locationPage;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.errorList);
            list.addAll(this.warningList);
            this.errorPage.getListViewer().setInput(list);
            return super.getNextPage(page);
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        if (!this.isDoTranslation) {
            this.translateBpmnToStrings();
        }
        this.createGeneratedFile(this.isOverWrite());
        this.refreshWorkspace();
        return true;
    }

    public abstract void translateBpmnToStrings();

    public abstract void createGeneratedFile(boolean var1);

    protected String getContainerPath(IContainer container) {
        return container.getLocation().toOSString();
    }

    public void refreshWorkspace() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public List<String> getPoolIdList() {
        return this.poolIdList;
    }

    public void setPoolIdList(List<String> poolIdList) {
        this.poolIdList = poolIdList;
    }

    public List<String> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(List<String> errorList) {
        this.errorList = errorList;
    }

    public List<String> getWarningList() {
        return this.warningList;
    }

    public void setWarningList(List<String> warningList) {
        this.warningList = warningList;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
        this.initialize();
    }

    public String getBpmnFileName() {
        return this.bpmnFileName;
    }

    public void setBpmnFileName(String bpmnFileName) {
        this.bpmnFileName = bpmnFileName;
    }

    public String getBpmnFileParentPath() {
        return this.bpmnFileParentPath;
    }

    public void setBpmnFileParentPath(String bpmnFileParentPath) {
        this.bpmnFileParentPath = bpmnFileParentPath;
    }

    public IStructuredSelection getTargetLocationSelection() {
        return this.targetLocationSelection;
    }

    public void setTargetLocationSelection(IStructuredSelection targetLocationSelection) {
        this.targetLocationSelection = targetLocationSelection;
    }

    public boolean isOverWrite() {
        return this.isOverWrite;
    }

    public void setOverWrite(boolean isOverWrite) {
        this.isOverWrite = isOverWrite;
    }
}

