/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.convert.bpmnto.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomXmlWriter {
    public static String toString(Document document) throws IOException {
        OutputFormat outputFormat = new OutputFormat("  ", true);
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, outputFormat);
        xmlWriter.write(document);
        xmlWriter.flush();
        ((Writer)writer).flush();
        return ((Object)writer).toString();
    }

    public static Document createDomTree(boolean useNamespace, String url, String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = null;
        if (useNamespace) {
            Namespace jbpmNamespace = new Namespace(null, url);
            root = document.addElement(rootElementName, jbpmNamespace.getURI());
        } else {
            root = document.addElement(rootElementName);
        }
        root.addText(System.getProperty("line.separator"));
        return document;
    }

    public static Element addElement(Element element, String elementName) {
        Element newElement = element.addElement(elementName);
        return newElement;
    }

    public static Element addElement(Element element, String elementName, int location) {
        Element newElement = null;
        if (element.elements(elementName) != null && element.elements(elementName).size() > location && location >= 0) {
            newElement = DocumentHelper.createElement((String)elementName);
            element.elements(elementName).add(location, newElement);
        }
        return newElement;
    }

    public static void addAttribute(Element e, String attributeName, String value) {
        if (value != null) {
            e.addAttribute(attributeName, value);
        }
    }

    public static List<Element> getElementsByName(Element element, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Object ele : element.elements()) {
            if (name.equals(((Element)ele).getName())) {
                list.add((Element)ele);
            }
            list.addAll(DomXmlWriter.getElementsByName((Element)ele, name));
        }
        return list;
    }

    public static void mapAttribute(Element ele, String attrName, Element sourceEle) {
        DomXmlWriter.addAttribute(ele, attrName, sourceEle.attributeValue(attrName));
    }
}

