/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.convert.bpmnto.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMNToUtil {
    public static File createFile(String parentFolder, String fileName, String inputStr, boolean isOverWrite) throws IOException {
        File child = new File(parentFolder, fileName);
        if (isOverWrite) {
            BPMNToUtil.deleteAll(child);
        }
        if (inputStr == null) {
            if (!child.exists()) {
                child.mkdir();
            }
        } else {
            if (!child.exists()) {
                child.createNewFile();
            }
            FileWriter childWriter = new FileWriter(child);
            PrintWriter printFile = new PrintWriter(childWriter);
            printFile.println(inputStr);
            printFile.close();
            childWriter.close();
        }
        return child;
    }

    public static void deleteAll(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            path.delete();
            return;
        }
        File[] files = path.listFiles();
        int i = 0;
        while (i < files.length) {
            BPMNToUtil.deleteAll(files[i]);
            ++i;
        }
        path.delete();
    }

    public static InputSource getInputSource(String parentFolder, String fileName) throws FileNotFoundException {
        return new InputSource(BPMNToUtil.getInputStream(parentFolder, fileName));
    }

    public static InputStream getInputStream(String parentFolder, String fileName) throws FileNotFoundException {
        File file = new File(parentFolder, fileName);
        FileInputStream input = new FileInputStream(file);
        return input;
    }

    public static Document parse(String parentFolder, String fileName) throws Exception {
        Document document = null;
        SAXReader saxReader = BPMNToUtil.createSaxReader();
        document = saxReader.read(BPMNToUtil.getInputSource(parentFolder, fileName));
        return document;
    }

    public static SAXReader createSaxReader() throws Exception {
        XMLReader xmlReader = BPMNToUtil.createXmlReader();
        SAXReader saxReader = new SAXReader(xmlReader);
        return saxReader;
    }

    public static XMLReader createXmlReader() throws Exception {
        SAXParser saxParser = BPMNToUtil.createSaxParserFactory().newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        return xmlReader;
    }

    private static SAXParserFactory createSaxParserFactory() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(true);
        return saxParserFactory;
    }

    public static Map<String, String> getPoolIDsFromDocument(Document document) {
        HashMap<String, String> poolIDMap = new HashMap<String, String>();
        Element diagram = document.getRootElement();
        for (Object pool : diagram.elements("pools")) {
            if (((Element)pool).attributeValue("iD") == null) continue;
            poolIDMap.put(((Element)pool).attributeValue("iD"), ((Element)pool).attributeValue("name"));
        }
        return poolIDMap;
    }
}

