/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.convert.b2j.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.eclipse.core.resources.IContainer;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.jbpm.convert.b2j.messages.B2JMessages;
import org.jboss.tools.jbpm.convert.b2j.translate.BPMN2JPDL;
import org.jboss.tools.jbpm.convert.b2j.translate.GraphicalFileGenerator;
import org.jboss.tools.jbpm.convert.b2j.translate.TranslateHelper;
import org.jboss.tools.jbpm.convert.bpmnto.BpmnToPlugin;
import org.jboss.tools.jbpm.convert.bpmnto.util.BPMNToUtil;
import org.jboss.tools.jbpm.convert.bpmnto.wizard.BpmnToWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class B2JExportWizard
extends BpmnToWizard {
    private List<String> strForProcessList = new ArrayList<String>();
    private List<String> strForGpdList = new ArrayList<String>();
    private List<String> generatedFoldersList = new ArrayList<String>();
    private List<String> generatedGpdFoldersList = new ArrayList<String>();

    @Override
    public void createGeneratedFile(boolean isOverWrite) {
        String pro;
        Iterator<String> iterator;
        String[] strs;
        String name;
        String[] jpdlFolderNames = new String[this.generatedFoldersList.size()];
        String location = super.getContainerPath((IContainer)super.getTargetLocationSelection().getFirstElement());
        int i = 0;
        if (this.strForProcessList.size() > 0) {
            Iterator<String> iterator2 = this.generatedFoldersList.iterator();
            while (iterator2.hasNext()) {
                jpdlFolderNames[i] = name = iterator2.next();
                ++i;
            }
            i = 0;
            strs = new String[this.strForProcessList.size()];
            iterator = this.strForProcessList.iterator();
            while (iterator.hasNext()) {
                strs[i] = pro = iterator.next();
                ++i;
            }
            try {
                TranslateHelper.createFiles(location, this.bpmnFileName, strs, jpdlFolderNames, "processdefinition.xml", isOverWrite);
            }
            catch (Exception e) {
                BpmnToPlugin.getDefault().logError(e.getMessage());
            }
        }
        if (this.strForGpdList.size() > 0) {
            i = 0;
            Iterator<String> e = this.generatedGpdFoldersList.iterator();
            while (e.hasNext()) {
                jpdlFolderNames[i] = name = e.next();
                ++i;
            }
            i = 0;
            strs = new String[this.strForGpdList.size()];
            iterator = this.strForGpdList.iterator();
            while (iterator.hasNext()) {
                strs[i] = pro = iterator.next();
                ++i;
            }
            try {
                TranslateHelper.createFiles(location, this.bpmnFileName, strs, jpdlFolderNames, "gpd.xml", false);
            }
            catch (Exception e2) {
                BpmnToPlugin.getDefault().logError(e2.getMessage());
            }
        }
    }

    @Override
    public void translateBpmnToStrings() {
        Document bpmnDocument = null;
        try {
            bpmnDocument = BPMNToUtil.parse(this.bpmnFileParentPath, this.bpmnFileName);
        }
        catch (Exception exception) {
            this.errorList.add(NLS.bind((String)B2JMessages.Translate_Error_File_CanNotRead, (Object)this.bpmnFileName));
        }
        BPMN2JPDL translator = new BPMN2JPDL(this.bpmnFileName, this.bpmnFileParentPath, this.poolIdList, bpmnDocument);
        this.setStrForProcessList(Arrays.asList(translator.translateToStrings()));
        for (Document def : translator.getProcessDefs()) {
            this.generatedFoldersList.add(def.getName());
        }
        this.warningList.addAll(translator.getWarnings());
        this.errorList.addAll(translator.getErrors());
        Document bpmnDiagramDocument = null;
        try {
            bpmnDiagramDocument = BPMNToUtil.parse(this.bpmnFileParentPath, TranslateHelper.getBpmnDiagramName(this.bpmnFileName));
        }
        catch (Exception exception) {
            this.errorList.add(NLS.bind((String)B2JMessages.Translate_Error_File_CanNotRead, (Object)TranslateHelper.getBpmnDiagramName(this.bpmnFileName)));
        }
        if (bpmnDiagramDocument != null) {
            GraphicalFileGenerator generator = new GraphicalFileGenerator(bpmnDiagramDocument, translator.getMap(), this.bpmnFileParentPath, this.bpmnFileName);
            this.setStrForGpdList(Arrays.asList(generator.translateToStrings()));
            for (Document def : generator.getGpdDefs()) {
                this.generatedGpdFoldersList.add(def.getRootElement().attributeValue("name"));
            }
            this.warningList.addAll(generator.getWarnings());
            this.errorList.addAll(generator.getErrors());
        }
    }

    public List<String> getStrForProcessList() {
        return this.strForProcessList;
    }

    public void setStrForProcessList(List<String> strForProcessList) {
        this.strForProcessList = strForProcessList;
    }

    public List<String> getStrForGpdList() {
        return this.strForGpdList;
    }

    public void setStrForGpdList(List<String> strForGpdList) {
        this.strForGpdList = strForGpdList;
    }

    public List<String> getGeneratedFoldersList() {
        return this.generatedFoldersList;
    }

    public void setGeneratedFoldersList(List<String> generatedFoldersList) {
        this.generatedFoldersList = generatedFoldersList;
    }
}

