/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.convert.b2j.translate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.tools.jbpm.convert.bpmnto.util.BPMNToUtil;
import org.jboss.tools.jbpm.convert.bpmnto.util.DomXmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateHelper {
    static Map<String, Integer> nameMap = new HashMap<String, Integer>();

    public static void setNameMap(Map<String, Integer> nameMap) {
        TranslateHelper.nameMap = nameMap;
    }

    public static String getBpmnDiagramName(String bpmnFileName) {
        return String.valueOf(bpmnFileName) + "_diagram";
    }

    public static Document createJpdlDomTree(boolean useNamespace) {
        return DomXmlWriter.createDomTree(useNamespace, "urn:jbpm.org:jpdl-3.2", "process-definition");
    }

    public static File[] createFiles(String parentFolder, String bpmnFileName, String[] strsForGenerate, String[] fileFolders, String fileName, boolean isOverWrite) throws IOException {
        File jpdlFolder = BPMNToUtil.createFile(parentFolder, "jpdl", null, isOverWrite);
        File diagramFolder = BPMNToUtil.createFile(jpdlFolder.getAbsolutePath(), bpmnFileName, null, false);
        File[] files = new File[strsForGenerate.length];
        File processFolder = null;
        int i = 0;
        String[] stringArray = strsForGenerate;
        int n = strsForGenerate.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            processFolder = BPMNToUtil.createFile(diagramFolder.getAbsolutePath(), fileFolders[i], null, false);
            files[i] = BPMNToUtil.createFile(processFolder.getAbsolutePath(), fileName, str, false);
            ++i;
            ++n2;
        }
        return files;
    }

    public static String generateProcessName(Element graph) {
        if ("BpmnDiagram".equals(graph.getName())) {
            return graph.attributeValue("name");
        }
        String str = TranslateHelper.generateProcessName(graph.getParent());
        if (str == null) {
            return TranslateHelper.generateElementName(graph);
        }
        return String.valueOf(str) + "." + TranslateHelper.generateElementName(graph);
    }

    public static String generateElementName(Element graph) {
        Integer i;
        String name = graph.attributeValue("name");
        if (name == null || "".equals(name)) {
            name = "eleName";
        }
        if ((i = nameMap.get(name)) == null) {
            nameMap.put(name, new Integer("1"));
        } else {
            i = i + 1;
            nameMap.put(name, i);
        }
        return name;
    }

    public static boolean check_mapElementName(Element graph, Element graphEle, boolean isTransition) {
        Integer i;
        boolean isOk = true;
        String name = graph.attributeValue("name");
        if (name == null || "".equals(name)) {
            name = isTransition ? "to_" + graphEle.attributeValue("to") : "eleName";
            isOk = false;
        }
        if ((i = nameMap.get(name)) == null) {
            DomXmlWriter.addAttribute(graphEle, "name", name);
            nameMap.put(name, new Integer("1"));
        } else {
            DomXmlWriter.addAttribute(graphEle, "name", String.valueOf(name) + "_" + i);
            i = i + 1;
            nameMap.put(name, i);
            isOk = false;
        }
        return isOk;
    }

    public static List<Element> locateLastElements(Element processRoot) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (processRoot.element("end-state") != null) {
            Element endState = processRoot.element("end-state");
            for (Object ele : processRoot.elements()) {
                Element subEle = ((Element)ele).element("transition");
                if (subEle == null || !endState.attributeValue("name").equals(subEle.attributeValue("to"))) continue;
                list.add((Element)ele);
            }
        } else {
            for (Object ele : processRoot.elements()) {
                if (((Element)ele).element("transition") != null) continue;
                list.add((Element)ele);
            }
        }
        return list;
    }

    public static Element getDiagramLayoutElement(String bpmnID, List<Element> eleList) {
        Element element = null;
        for (Element ele : eleList) {
            String str = ele.attributeValue("href");
            if (str == null || !str.contains(bpmnID)) continue;
            element = ele;
            break;
        }
        if (element != null && element.getParent().element("layoutConstraint") != null) {
            return element.getParent().element("layoutConstraint");
        }
        return null;
    }

    public static Element createTransition(Element parentEle, String name, Element jpdlEle) {
        Element ele = DomXmlWriter.addElement(parentEle, name);
        DomXmlWriter.mapAttribute(ele, "name", jpdlEle);
        Element label = DomXmlWriter.addElement(ele, "label");
        TranslateHelper.mapXY(label, "5", "-10");
        return ele;
    }

    private static Element createElement(Element parentEle, String name, String width, String height) {
        Element ele = DomXmlWriter.addElement(parentEle, name);
        DomXmlWriter.addAttribute(ele, "width", width);
        DomXmlWriter.addAttribute(ele, "height", height);
        return ele;
    }

    public static Element createNode(Element rootEle, String name, Element jpdlEle) {
        Element ele = TranslateHelper.createElement(rootEle, name, "100", "40");
        DomXmlWriter.mapAttribute(ele, "name", jpdlEle);
        return ele;
    }

    public static void mapXY(Element pgdEle, String x, String y) {
        DomXmlWriter.addAttribute(pgdEle, "x", x == null ? "0" : x);
        DomXmlWriter.addAttribute(pgdEle, "y", y == null ? "0" : y);
    }

    public static String getPureBpmnID(String bpmnID, String suffix) {
        return bpmnID.substring(0, bpmnID.length() - suffix.length());
    }

    public static String[] getXY(Element bpmnGpdEle, int xIncre, int yIncre) {
        String[] xy = new String[2];
        if (bpmnGpdEle == null) {
            xy[0] = String.valueOf(xIncre);
            xy[1] = String.valueOf(yIncre);
        } else {
            xy[0] = String.valueOf(Integer.parseInt(bpmnGpdEle.attributeValue("x") == null ? "0" : bpmnGpdEle.attributeValue("x")) + xIncre);
            xy[1] = String.valueOf(Integer.parseInt(bpmnGpdEle.attributeValue("y") == null ? "0" : bpmnGpdEle.attributeValue("y")) + yIncre);
        }
        return xy;
    }
}

