/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.convert.b2j.translate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.tools.jbpm.convert.b2j.translate.TranslateHelper;
import org.jboss.tools.jbpm.convert.bpmnto.translate.BPMNTranslator;
import org.jboss.tools.jbpm.convert.bpmnto.util.BPMNToUtil;
import org.jboss.tools.jbpm.convert.bpmnto.util.DomXmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalFileGenerator
extends BPMNTranslator {
    private Document document;
    private List<Document> gpdDefs = new ArrayList<Document>();
    private List<String> gpdPoolNames = new ArrayList<String>();
    private Map<String, Element> map = new HashMap<String, Element>();

    public GraphicalFileGenerator(Document bpmnDiagramDocument, Map<String, Element> map, String rootLocation, String bpmnFileName) {
        super(bpmnFileName, rootLocation, null);
        this.document = bpmnDiagramDocument;
        this.map = map;
    }

    public GraphicalFileGenerator(Map<String, Element> map, String rootLocation, String bpmnFileName) {
        this(null, map, rootLocation, bpmnFileName);
    }

    public String[] translateToStrings() {
        this.translateDiagram();
        String[] strForProcessDefs = new String[this.gpdDefs.size()];
        int i = 0;
        for (Document def : this.gpdDefs) {
            try {
                strForProcessDefs[i] = DomXmlWriter.toString(def);
            }
            catch (IOException e) {
                this.errors.add("Error: Couldn't write gpd.xml:" + e.getMessage());
            }
            ++i;
        }
        return strForProcessDefs;
    }

    public void translateToFiles(String fileLocation) {
        String[] strForGpdDefs = this.translateToStrings();
        String[] gpdFileNames = new String[this.gpdDefs.size()];
        int i = 0;
        for (Document def : this.gpdDefs) {
            gpdFileNames[i] = def.getRootElement().attributeValue("name");
            ++i;
        }
        try {
            TranslateHelper.createFiles(fileLocation, this.bpmnFileName, strForGpdDefs, gpdFileNames, "gpd.xml", false);
        }
        catch (Exception e) {
            this.errors.add("Error: Couldn't write gpd definition to a gpd.xml:" + e.getMessage());
        }
    }

    @Override
    public void translateDiagram() {
        if (this.document == null) {
            try {
                this.document = BPMNToUtil.parse(this.rootLocation, this.bpmnFileName);
            }
            catch (Exception e) {
                this.errors.add("Error: Couldn't read or parse the file to a DOM document:" + e.getMessage());
            }
        }
        Element rootElement = this.document.getRootElement();
        List<Element> eleList = DomXmlWriter.getElementsByName(rootElement, "element");
        for (String bpmnID : this.map.keySet()) {
            if (bpmnID == null) continue;
            int xIncre = 0;
            int yIncre = 0;
            Element bpmnGpdEle = TranslateHelper.getDiagramLayoutElement(bpmnID, eleList);
            if (bpmnGpdEle == null) {
                if (bpmnID.endsWith("vertices")) {
                    bpmnGpdEle = TranslateHelper.getDiagramLayoutElement(TranslateHelper.getPureBpmnID(bpmnID, "vertices"), eleList);
                    xIncre = 150;
                    yIncre = 50;
                } else if (bpmnID.endsWith("Decision")) {
                    bpmnGpdEle = TranslateHelper.getDiagramLayoutElement(TranslateHelper.getPureBpmnID(bpmnID, "Decision"), eleList);
                    xIncre = 150;
                    yIncre = 100;
                } else if (bpmnID.endsWith("Complete")) {
                    bpmnGpdEle = TranslateHelper.getDiagramLayoutElement(TranslateHelper.getPureBpmnID(bpmnID, "Complete"), eleList);
                    xIncre = 300;
                    yIncre = 0;
                } else if (bpmnID.endsWith("Cancel")) {
                    bpmnGpdEle = TranslateHelper.getDiagramLayoutElement(TranslateHelper.getPureBpmnID(bpmnID, "Cancel"), eleList);
                    xIncre = 300;
                    yIncre = 200;
                } else if (bpmnID.endsWith("pools")) continue;
            }
            this.translateGraphicalElement(TranslateHelper.getXY(bpmnGpdEle, xIncre, yIncre), this.map.get(bpmnID), eleList);
        }
    }

    private void translateGraphicalElement(String[] xy, Element jpdlEle, List<Element> eleList) {
        if (jpdlEle == null) {
            return;
        }
        if (!this.gpdPoolNames.contains(jpdlEle.getParent().attributeValue("name")) && "process-definition".equals(jpdlEle.getParent().getName())) {
            this.translatePool(eleList, jpdlEle);
        }
        Element poolEle = null;
        for (Document doc : this.gpdDefs) {
            if (!doc.getRootElement().attributeValue("name").equals(jpdlEle.getParent().attributeValue("name"))) continue;
            poolEle = doc.getRootElement();
        }
        Element pgdEle = TranslateHelper.createNode(poolEle, "node", jpdlEle);
        TranslateHelper.mapXY(pgdEle, xy[0], xy[1]);
        for (Object ele : jpdlEle.elements("transition")) {
            TranslateHelper.createTransition(pgdEle, "edge", (Element)ele);
        }
    }

    private void translatePool(List<Element> eleList, Element jpdlEle) {
        String poolBpmnID = null;
        for (String id : this.map.keySet()) {
            if (this.map.get(id) != jpdlEle.getParent()) continue;
            poolBpmnID = TranslateHelper.getPureBpmnID(id, "pools");
            break;
        }
        if (poolBpmnID != null) {
            Element poolBpmnGpdEle = TranslateHelper.getDiagramLayoutElement(poolBpmnID, eleList);
            Document processDiagramDef = DomXmlWriter.createDomTree(false, null, "root-container");
            Element poolEle = processDiagramDef.getRootElement();
            DomXmlWriter.mapAttribute(poolEle, "name", jpdlEle.getParent());
            DomXmlWriter.mapAttribute(poolEle, "width", poolBpmnGpdEle);
            DomXmlWriter.mapAttribute(poolEle, "height", poolBpmnGpdEle);
            this.gpdDefs.add(processDiagramDef);
            this.gpdPoolNames.add(poolEle.attributeValue("name"));
        }
    }

    public List<Document> getGpdDefs() {
        return this.gpdDefs;
    }

    public void setGpdDefs(List<Document> gpdDefs) {
        this.gpdDefs = gpdDefs;
    }
}

