/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProcessInformationStore {
    private static ProcessInformationStore singleton;
    protected Map<Integer, String> processInformationStore = new HashMap<Integer, String>();

    public static synchronized ProcessInformationStore getDefault() {
        if (singleton == null) {
            singleton = new ProcessInformationStore();
        }
        return singleton;
    }

    public synchronized String queryProcessInformation(int pid) {
        if (!this.processInformationStore.containsKey(pid)) {
            this.refreshProcessInformationStoreAsync();
        }
        return this.processInformationStore.get(pid);
    }

    public void refreshProcessInformationStore() {
        this.refreshProcessInformationStore((IProgressMonitor)new NullProgressMonitor());
    }

    public void refreshProcessInformationStore(IProgressMonitor monitor) {
        this.setProcessStore(this.loadProcessStore(monitor));
    }

    private synchronized void setProcessStore(Map<Integer, String> store) {
        if (store != null) {
            this.processInformationStore = store;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<Integer, String> loadProcessStore(IProgressMonitor monitor) {
        HashMap<Integer, String> tmp = new HashMap<Integer, String>();
        String path = String.format("%s%sbin%s", System.getProperty("java.home"), File.separator, File.separator);
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("jps");
        cmds.add("-v");
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.directory(new File(path));
        BufferedReader br = null;
        Process p = pb.start();
        br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = "";
        while (!monitor.isCanceled() && (line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, " ");
            int pid = -1;
            if (st.hasMoreElements()) {
                String sVal = st.nextToken();
                try {
                    pid = Integer.parseInt(sVal);
                }
                catch (NumberFormatException numberFormatException) {
                    pid = -1;
                }
            }
            if (pid == -1) continue;
            tmp.put(pid, line);
        }
        HashMap<Integer, String> hashMap = tmp;
        if (br == null) return hashMap;
        try {
            br.close();
            return hashMap;
        }
        catch (Exception exception) {}
        return hashMap;
        catch (Exception exception) {
            try {
                if (br == null) return null;
            }
            catch (Throwable throwable) {
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                br.close();
                return null;
            }
            catch (Exception exception3) {}
            return null;
        }
    }

    public void refreshProcessInformationStoreAsync() {
        new Job("Refreshing Process Information"){

            protected IStatus run(IProgressMonitor monitor) {
                ProcessInformationStore.this.refreshProcessInformationStore(monitor);
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

