/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.jmx.local.IJvmConnectionHandler;
import org.jboss.tools.jmx.local.internal.Activator;

public class JmxLocalExtensionManager {
    private static JmxLocalExtensionManager instance;
    private ArrayList<HandlerWrapper> handlers = null;

    public static synchronized JmxLocalExtensionManager getDefault() {
        if (instance == null) {
            instance = new JmxLocalExtensionManager();
        }
        return instance;
    }

    public JmxLocalExtensionManager() {
        this.loadJvmHandlers();
    }

    public void loadJvmHandlers() {
        this.handlers = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(Activator.PLUGIN_ID, "jvmConnectionHandler");
        int i = 0;
        while (i < cf.length) {
            HandlerWrapper sspt = new HandlerWrapper(cf[i]);
            this.handlers.add(sspt);
            ++i;
        }
        Collections.sort(this.handlers, new Comparator<HandlerWrapper>(){

            @Override
            public int compare(HandlerWrapper o1, HandlerWrapper o2) {
                return o1.getWeight() - o2.getWeight();
            }
        });
    }

    public IJvmConnectionHandler[] getJvmConnectionHandlers() {
        ArrayList<IJvmConnectionHandler> ret = new ArrayList<IJvmConnectionHandler>();
        Iterator<HandlerWrapper> i = this.handlers.iterator();
        while (i.hasNext()) {
            IJvmConnectionHandler h = i.next().getHandler();
            if (h == null) continue;
            ret.add(h);
        }
        return ret.toArray(new IJvmConnectionHandler[ret.size()]);
    }

    private static class HandlerWrapper {
        private IConfigurationElement el;
        private IJvmConnectionHandler handler;
        private boolean loadFailed = false;

        public HandlerWrapper(IConfigurationElement el) {
            this.el = el;
        }

        public int getWeight() {
            String s = this.el.getAttribute("weight");
            try {
                if (s != null) {
                    int i = Integer.parseInt(s);
                    return i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return -1;
        }

        public IJvmConnectionHandler getHandler() {
            if (this.handler == null && !this.loadFailed) {
                try {
                    this.handler = (IJvmConnectionHandler)this.el.createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    this.loadFailed = true;
                }
            }
            return this.handler;
        }
    }
}

