/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.jmx.core.AbstractConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionCategory;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IHost;
import org.jboss.tools.jmx.jvmmonitor.core.IJvmModelChangeListener;
import org.jboss.tools.jmx.jvmmonitor.core.JvmModel;
import org.jboss.tools.jmx.jvmmonitor.core.JvmModelEvent;
import org.jboss.tools.jmx.local.internal.JvmConnectionWrapper;
import org.jboss.tools.jmx.local.internal.JvmKey;

public class JVMConnectionProvider
extends AbstractConnectionProvider
implements IConnectionProvider,
IConnectionCategory {
    public static final String PROVIDER_ID = "org.jboss.tools.jmx.local.JVMConnectionProvider";
    private HashMap<JvmKey, JvmConnectionWrapper> connections;
    IJvmModelChangeListener listener = null;

    public String getId() {
        return PROVIDER_ID;
    }

    public String getName(IConnectionWrapper wrapper) {
        return ((JvmConnectionWrapper)wrapper).getName();
    }

    public IConnectionWrapper findConnection(IActiveJvm jvm) {
        this.getConnections();
        JvmKey key = this.getJvmKey(jvm);
        return this.connections.get(key);
    }

    public IConnectionWrapper[] getConnections() {
        if (this.connections == null) {
            this.loadConnections();
        }
        if (this.connections != null) {
            ArrayList<JvmConnectionWrapper> result = new ArrayList<JvmConnectionWrapper>();
            result.addAll(this.connections.values());
            Collections.sort(result, new Comparator<IConnectionWrapper>(){

                @Override
                public int compare(IConnectionWrapper o1, IConnectionWrapper o2) {
                    String name1 = JVMConnectionProvider.this.getName(o1);
                    String name2 = JVMConnectionProvider.this.getName(o2);
                    if (name1 == null) {
                        return name2 == null ? 0 : -1;
                    }
                    if (name2 == null) {
                        return 1;
                    }
                    return name1.compareTo(name2);
                }
            });
            return result.toArray(new IConnectionWrapper[result.size()]);
        }
        return new IConnectionWrapper[0];
    }

    private void loadConnections() {
        JvmModel model = JvmModel.getInstance();
        if (this.listener == null) {
            this.listener = new IJvmModelChangeListener(){

                public void jvmModelChanged(JvmModelEvent e) {
                    JVMConnectionProvider.this.handleJvmModelChanged();
                }
            };
            model.addJvmModelChangeListener(this.listener);
        }
        HashMap<JvmKey, JvmConnectionWrapper> fromModel = this.loadFromJVMModel(model);
        this.connections = fromModel;
    }

    private void handleJvmModelChanged() {
        JvmModel model = JvmModel.getInstance();
        HashMap<JvmKey, JvmConnectionWrapper> fromModel = this.loadFromJVMModel(model);
        IConnectionWrapper[] added = this.findAdded(fromModel);
        IConnectionWrapper[] removed = this.findRemoved(fromModel);
        IConnectionWrapper[] changed = this.findAndUpdateChanged(fromModel);
        if (added.length > 0 || removed.length > 0 || changed.length > 0) {
            this.fireAllAdded(added);
            this.fireAllRemoved(removed);
            this.fireAllChanged(changed);
            this.connections = fromModel;
        }
    }

    private JvmConnectionWrapper[] findAdded(HashMap<JvmKey, JvmConnectionWrapper> newModel) {
        ArrayList<JvmConnectionWrapper> list = new ArrayList<JvmConnectionWrapper>();
        for (JvmKey working : newModel.keySet()) {
            if (this.connections.get(working) != null) continue;
            list.add(newModel.get(working));
        }
        return list.toArray(new JvmConnectionWrapper[list.size()]);
    }

    private JvmConnectionWrapper[] findRemoved(HashMap<JvmKey, JvmConnectionWrapper> newModel) {
        ArrayList<JvmConnectionWrapper> list = new ArrayList<JvmConnectionWrapper>();
        for (JvmKey working : this.connections.keySet()) {
            if (newModel.get(working) != null) continue;
            list.add(newModel.get(working));
        }
        return list.toArray(new JvmConnectionWrapper[list.size()]);
    }

    private JvmConnectionWrapper[] findAndUpdateChanged(HashMap<JvmKey, JvmConnectionWrapper> newModel) {
        ArrayList<JvmConnectionWrapper> list = new ArrayList<JvmConnectionWrapper>();
        for (JvmKey working : this.connections.keySet()) {
            IActiveJvm oldJvm;
            IActiveJvm newJvm;
            if (newModel.get(working) == null || this.safeEquals(newJvm = working.getJvm(), oldJvm = this.connections.get(working).getActiveJvm())) continue;
            JvmConnectionWrapper oldWrapper = this.connections.get(working);
            oldWrapper.setActiveJvm(newJvm);
            newModel.put(working, oldWrapper);
            list.add(newModel.get(oldWrapper));
        }
        return list.toArray(new JvmConnectionWrapper[list.size()]);
    }

    private boolean safeEquals(IActiveJvm j1, IActiveJvm j2) {
        if (j1 == null) {
            return j2 == null;
        }
        return j1.equals(j2);
    }

    private HashMap<JvmKey, JvmConnectionWrapper> loadFromJVMModel(JvmModel model) {
        HashMap<JvmKey, JvmConnectionWrapper> ret = new HashMap<JvmKey, JvmConnectionWrapper>();
        List hosts = model.getHosts();
        for (IHost host : hosts) {
            List jvms = host.getActiveJvms();
            for (IActiveJvm jvm : jvms) {
                JvmKey key = this.getJvmKey(jvm);
                JvmConnectionWrapper working = new JvmConnectionWrapper(jvm);
                ret.put(key, working);
            }
        }
        return ret;
    }

    public JvmKey getJvmKey(IActiveJvm jvm) {
        int pid = jvm.getPid();
        String hostName = jvm.getHost().getName();
        return new JvmKey(hostName, pid, jvm);
    }

    public IConnectionWrapper createConnection(Map map) throws CoreException {
        return null;
    }

    public boolean canCreate() {
        return false;
    }

    public boolean canDelete(IConnectionWrapper wrapper) {
        return false;
    }

    public void addConnection(IConnectionWrapper connection) {
    }

    public void removeConnection(IConnectionWrapper connection) {
    }

    public void connectionChanged(IConnectionWrapper connection) {
    }

    public String getCategoryId() {
        return "IConnectionCategory.process";
    }
}

