/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.extract.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.runtime.core.extract.IOverwrite;
import org.jboss.tools.runtime.core.extract.internal.IExtractUtility;
import org.jboss.tools.runtime.core.extract.internal.xpl.TarEntry;
import org.jboss.tools.runtime.core.extract.internal.xpl.TarInputStream;

public class UntarUtility
implements IExtractUtility {
    private static final String SEPARATOR = "/";
    protected File file;
    private String discoveredRoot = null;
    private boolean rootEntryImpossible = false;
    private byte[] BUFFER = null;

    public UntarUtility(File file) {
        this.file = file;
    }

    @Override
    public IStatus extract(File destination, IOverwrite overwriteQuery, IProgressMonitor monitor) throws CoreException {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(this.file);
                this.untar(in, (IPath)new Path(destination.getAbsolutePath()), monitor);
            }
            catch (IOException ioe) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.runtime.core", 0, NLS.bind((String)"Error extracting runtime", (Object)ioe.getLocalizedMessage()), (Throwable)ioe));
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            monitor.done();
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        monitor.done();
        return null;
    }

    protected void untar(InputStream in, IPath path, IProgressMonitor monitor) throws IOException {
        String possibleRoot = null;
        int fileCnt = -1;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(fileCnt > 0 ? fileCnt : 500));
        String archivePath = null;
        BufferedInputStream bin = new BufferedInputStream(in);
        TarInputStream zin = new TarInputStream(bin);
        TarEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            progress.subTask(NLS.bind((String)"Uncompressing {0}", (Object)name));
            if (archivePath != null && name.startsWith(archivePath) && (name = name.substring(archivePath.length())).length() > 1) {
                name = name.substring(1);
            }
            if (name != null && name.length() > 0) {
                if (entry.getFileType() == 53) {
                    path.append(name).toFile().mkdirs();
                } else {
                    File dir = path.append(name).removeLastSegments(1).toFile();
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                    this.copyWithSize(zin, fout, (IProgressMonitor)progress.newChild(1), (int)entry.getSize());
                    fout.close();
                    if (fileCnt <= 0) {
                        progress.setWorkRemaining(500);
                    }
                }
            }
            if (!this.rootEntryImpossible && this.discoveredRoot == null) {
                if (name == null || name.isEmpty() || name.startsWith(SEPARATOR) || name.indexOf(SEPARATOR) == -1) {
                    this.rootEntryImpossible = true;
                    possibleRoot = null;
                } else {
                    String directory = name.substring(0, name.indexOf(SEPARATOR));
                    if (possibleRoot == null) {
                        possibleRoot = directory;
                    } else if (!directory.equals(possibleRoot)) {
                        this.rootEntryImpossible = true;
                        possibleRoot = null;
                    }
                }
            }
            entry = zin.getNextEntry();
        }
        this.discoveredRoot = possibleRoot;
        zin.close();
    }

    protected void copyWithSize(InputStream in, OutputStream out, IProgressMonitor monitor, int size) throws IOException {
        if (this.BUFFER == null) {
            this.BUFFER = new byte[8192];
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        int r = in.read(this.BUFFER);
        while (r >= 0) {
            out.write(this.BUFFER, 0, r);
            progress.worked(r);
            r = in.read(this.BUFFER);
        }
    }

    @Override
    public String getRoot(IProgressMonitor monitor) throws CoreException {
        if (this.discoveredRoot != null) {
            return this.discoveredRoot;
        }
        if (this.rootEntryImpossible) {
            return null;
        }
        return null;
    }
}

