/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;
import org.jboss.tools.vpe.browsersim.ui.BrowserSim;
import org.jboss.tools.vpe.browsersim.util.PreferencesUtil;

public class ManifestUtil {
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";

    public static String getManifestVersion() {
        URLClassLoader classLoader = (URLClassLoader)BrowserSim.class.getClassLoader();
        String version = null;
        try {
            URL browserSimBaseUrl;
            Enumeration<URL> manifestUrls = classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifestUrls.hasMoreElements()) {
                Manifest manifest;
                String manifestVersion;
                URL manifestUrl = manifestUrls.nextElement();
                InputStream inputStream = manifestUrl.openStream();
                if (inputStream == null || PreferencesUtil.isNullOrEmpty(manifestVersion = ManifestUtil.getManifestVersion(manifest = new Manifest(inputStream)))) continue;
                version = manifestVersion;
            }
            if (version == null && (browserSimBaseUrl = BrowserSim.class.getClassLoader().getResource(".")) != null && "file".equals(browserSimBaseUrl.getProtocol())) {
                File binDir = new File(browserSimBaseUrl.getFile());
                File browsersimDir = binDir.getParentFile();
                File manifestFile = new File(browsersimDir, "META-INF/MANIFEST.MF");
                FileInputStream inputStream = new FileInputStream(manifestFile);
                Manifest manifestFromFile = new Manifest(inputStream);
                version = ManifestUtil.getManifestVersion(manifestFromFile);
            }
        }
        catch (IOException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
            version = null;
        }
        return version;
    }

    private static String getManifestVersion(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        String version = null;
        String bundleId = mainAttributes.getValue(BUNDLE_SYMBOLIC_NAME);
        if (bundleId != null && bundleId.startsWith("org.jboss.tools.vpe.browsersim")) {
            version = mainAttributes.getValue(BUNDLE_VERSION);
        }
        return version;
    }
}

