/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui.skin.android;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.vpe.browsersim.ui.skin.DeviceComposite;
import org.jboss.tools.vpe.browsersim.ui.skin.ImageButtonComposite;
import org.jboss.tools.vpe.browsersim.ui.skin.ImageDescriptor;
import org.jboss.tools.vpe.browsersim.ui.skin.android.AndroidNavBarComposite;
import org.jboss.tools.vpe.browsersim.ui.skin.android.AndroidSkinDescriptor;
import org.jboss.tools.vpe.browsersim.ui.skin.android.AndroidTimeComposite;
import org.jboss.tools.vpe.browsersim.util.BrowserSimImageList;

public class AndroidComposite
extends DeviceComposite {
    private BrowserSimImageList imageList = new BrowserSimImageList((Widget)this);
    private Composite androidOsCompositeContainer;
    private Composite browserContainer;
    private AndroidNavBarComposite navBarComposite;
    private ImageButtonComposite forwardButtonComposite;
    private ImageButtonComposite backButtonComposite;
    private ImageButtonComposite homeButtonComposite;
    private ImageButtonComposite refreshButtonComposite;
    private int cornersSize;

    public AndroidComposite(Composite parent, AndroidSkinDescriptor skinDescriptor) {
        super(parent, 0);
        this.setLayout((Layout)new FormLayout());
        this.backButtonComposite = new ImageButtonComposite(this, this.imageList, skinDescriptor.getBackButton());
        if (skinDescriptor.getForwardButton() != null) {
            this.forwardButtonComposite = new ImageButtonComposite(this, this.imageList, skinDescriptor.getForwardButton());
        }
        this.refreshButtonComposite = new ImageButtonComposite(this, this.imageList, skinDescriptor.getRefreshButton());
        this.homeButtonComposite = new ImageButtonComposite(this, this.imageList, skinDescriptor.getHomeButton());
        this.bodyComposite = new Composite((Composite)this, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.bodyComposite.setLayoutData((Object)formData);
        GridLayout gridLayout = new GridLayout(skinDescriptor.getBodyGridSize(), false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.bodyComposite.setLayout((Layout)gridLayout);
        ImageDescriptor[] imageDescriptorArray = skinDescriptor.getBodyGridImageDescriptors();
        int n = imageDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor descriptor = imageDescriptorArray[n2];
            Composite composite = descriptor.createWidget(this.bodyComposite, this.imageList);
            if (descriptor == skinDescriptor.getAndroidOSDescriptor()) {
                this.androidOsCompositeContainer = composite;
            }
            ++n2;
        }
        gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.androidOsCompositeContainer.setLayout((Layout)gridLayout);
        AndroidTimeComposite timeComposite = new AndroidTimeComposite(this.androidOsCompositeContainer, this.imageList);
        GridData gridData = new GridData(4, 1, true, false, 1, 1);
        timeComposite.setLayoutData(gridData);
        this.navBarComposite = new AndroidNavBarComposite(this.androidOsCompositeContainer, this.imageList);
        gridData = new GridData(4, 1, true, false, 1, 1);
        this.navBarComposite.setLayoutData(gridData);
        this.browserContainer = new Composite(this.androidOsCompositeContainer, 0);
        gridData = new GridData(4, 4, true, true, 1, 1);
        this.browserContainer.setLayoutData((Object)gridData);
        this.cornersSize = skinDescriptor.getCornersSize();
        timeComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    AndroidComposite.this.setNavBarCompositeVisible(!AndroidComposite.this.isNavBarCompositeVisible());
                }
            }
        });
    }

    @Override
    public ImageButtonComposite getBackButtonComposite() {
        return this.backButtonComposite;
    }

    @Override
    public ImageButtonComposite getForwardButtonComposite() {
        return this.forwardButtonComposite;
    }

    @Override
    public Composite getBrowserContainer() {
        return this.browserContainer;
    }

    protected void checkSubclass() {
    }

    @Override
    public void setNavBarCompositeVisible(boolean visible) {
        GridData gridData = (GridData)this.navBarComposite.getLayoutData();
        gridData.heightHint = visible ? -1 : 0;
        this.androidOsCompositeContainer.layout();
    }

    @Override
    public boolean isNavBarCompositeVisible() {
        GridData gridData = (GridData)this.navBarComposite.getLayoutData();
        return gridData.heightHint != 0;
    }

    @Override
    public ImageButtonComposite getStopButtonComposite() {
        return this.navBarComposite.getStopButtonComposite();
    }

    @Override
    public ImageButtonComposite getRefreshButtonComposite() {
        return this.refreshButtonComposite;
    }

    @Override
    public ImageButtonComposite getHomeButtonComposite() {
        return this.homeButtonComposite;
    }

    @Override
    public Text getUrlText() {
        return this.navBarComposite.getUrlText();
    }

    @Override
    public ProgressBar getProgressBar() {
        return this.navBarComposite.getProgressBar();
    }

    @Override
    public StyledText getPageTitleStyledText() {
        return null;
    }

    @Override
    protected int getCornersSize() {
        return this.cornersSize;
    }
}

