/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui.skin;

import java.util.Arrays;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.IBrowserSimBrowserFactory;
import org.jboss.tools.vpe.browsersim.ui.ControlHandler;
import org.jboss.tools.vpe.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.vpe.browsersim.ui.skin.DeviceComposite;
import org.jboss.tools.vpe.browsersim.ui.skin.ResizableSkinSizeAdvisor;
import org.jboss.tools.vpe.browsersim.ui.skin.TextSelectionUtil;
import org.jboss.tools.vpe.browsersim.util.BrowserSimImageList;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;

public abstract class ResizableSkin
implements BrowserSimSkin {
    protected DeviceComposite deviceComposite;
    protected ControlHandler controlHandler;
    private IBrowserSimBrowserFactory browserFactory;
    private Display display;
    private Shell shell;
    private IBrowser browser;
    private boolean vertical;
    private int[] visibleRegionHorizontal;
    private int[] visibleRegionVertical;
    private Point horizontalBorderSize;
    private Point verticalBorderSize;
    private Point maxScreenSize;
    private Composite innerBrowserContainer;

    public ResizableSkin(int[] visibleRegionHorizontal, int[] visibleRegionVertical, Point normalScreenSize, Point normalSkinSize) {
        this.visibleRegionHorizontal = visibleRegionHorizontal;
        this.visibleRegionVertical = visibleRegionVertical;
        this.maxScreenSize = normalScreenSize;
        this.verticalBorderSize = new Point(normalSkinSize.x - normalScreenSize.x, normalSkinSize.y - normalScreenSize.y);
        this.horizontalBorderSize = new Point(this.verticalBorderSize.y, this.verticalBorderSize.x);
    }

    @Override
    public void createControls(Display display, Point location, Shell parentShell, boolean javaFx) {
        this.display = display;
        this.shell = parentShell == null ? new Shell(display, 262152) : new Shell(parentShell, 262152);
        this.shell.setLayout((Layout)new FillLayout());
        this.vertical = true;
        this.deviceComposite = this.createDeviceComposite((Composite)this.shell, this.vertical);
        this.bindDeviceCompositeControls();
        Composite browserContainer = this.deviceComposite.getBrowserContainer();
        browserContainer.setLayout((Layout)new FillLayout());
        StackLayout stackLayout = new StackLayout();
        this.innerBrowserContainer = new Composite(browserContainer, 0);
        this.innerBrowserContainer.setLayout((Layout)stackLayout);
        this.browser = this.browserFactory.createBrowser(this.innerBrowserContainer, 0, javaFx);
        stackLayout.topControl = (Control)this.browser;
        this.shell.setSize(384, 727);
        this.setShellRegion();
    }

    protected void bindDeviceCompositeControls() {
        this.deviceComposite.getBackButtonComposite().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    ResizableSkin.this.controlHandler.goBack();
                }
            }
        });
        if (this.deviceComposite.getForwardButtonComposite() != null) {
            this.deviceComposite.getForwardButtonComposite().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button == 1) {
                        ResizableSkin.this.controlHandler.goForward();
                    }
                }
            });
        }
        this.deviceComposite.getStopButtonComposite().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    ResizableSkin.this.controlHandler.stop();
                }
            }
        });
        this.deviceComposite.getRefreshButtonComposite().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    ResizableSkin.this.controlHandler.refresh();
                }
            }
        });
        if (this.deviceComposite.getHomeButtonComposite() != null) {
            this.deviceComposite.getHomeButtonComposite().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button == 1) {
                        ResizableSkin.this.controlHandler.goHome();
                    }
                }
            });
        }
        this.deviceComposite.getUrlText().addListener(14, new Listener(){

            public void handleEvent(Event e) {
                ResizableSkin.this.controlHandler.goToAddress(((Text)e.widget).getText());
            }
        });
        TextSelectionUtil.addSelectTextOnFocusListener(this.deviceComposite.getUrlText());
        Listener moveListener = new Listener(){
            Point origin;
            Point shellOrigin;

            public void handleEvent(Event e) {
                if (e.widget instanceof Composite && ((e.stateMask & 0x80000) != 0 || e.button == 1)) {
                    Composite composite = (Composite)e.widget;
                    Shell shell = composite.getShell();
                    switch (e.type) {
                        case 3: {
                            this.origin = e.display.map((Control)shell, null, e.x, e.y);
                            this.shellOrigin = shell.getLocation();
                            break;
                        }
                        case 4: {
                            this.origin = null;
                            break;
                        }
                        case 5: {
                            if (this.origin == null) break;
                            Point p = e.display.map((Control)shell, null, e.x, e.y);
                            Point location = new Point(this.shellOrigin.x + p.x - this.origin.x, this.shellOrigin.y + p.y - this.origin.y);
                            shell.setLocation(location.x, location.y);
                        }
                    }
                }
            }
        };
        this.deviceComposite.addListener(3, moveListener);
        this.deviceComposite.addListener(4, moveListener);
        this.deviceComposite.addListener(5, moveListener);
        final BrowserSimImageList imageList = new BrowserSimImageList((Widget)this.deviceComposite);
        Listener rotationHotSpotListener = new Listener(){

            public void handleEvent(Event event) {
                Control contol = event.display.getCursorControl();
                Point displayPoint = event.display.getCursorLocation();
                Image rotateImage = imageList.getImage("cursors/rotate.gif");
                if (ResizableSkin.this.deviceComposite.isDeviceCorner(displayPoint) && ResizableSkin.this.deviceComposite.isDeviceBody(contol)) {
                    ResizableSkin.this.deviceComposite.setCursor(new Cursor((Device)Display.getCurrent(), rotateImage.getImageData(), 0, 0));
                    BrowserSimUtil.addDisposeListener((Widget)ResizableSkin.this.deviceComposite, (Resource)ResizableSkin.this.deviceComposite.getCursor());
                } else {
                    ResizableSkin.this.deviceComposite.setCursor(null);
                }
            }
        };
        this.deviceComposite.addListener(5, rotationHotSpotListener);
        this.deviceComposite.addListener(7, rotationHotSpotListener);
        Listener rotationHotSpotClickListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    Control contol = event.display.getCursorControl();
                    Point displayPoint = event.display.getCursorLocation();
                    if (ResizableSkin.this.deviceComposite.isDeviceCorner(displayPoint) && ResizableSkin.this.deviceComposite.isDeviceBody(contol)) {
                        ResizableSkin.this.controlHandler.rotate(false);
                    }
                }
            }
        };
        this.deviceComposite.addListener(3, rotationHotSpotClickListener);
    }

    private void setShellRegion() {
        int[] normalRegion = this.getNormalRegion(this.vertical);
        Point normalRegionSize = new Point(0, 0);
        int i = 0;
        while (i < normalRegion.length) {
            if (normalRegionSize.x < normalRegion[i]) {
                normalRegionSize.x = normalRegion[i];
            }
            if (normalRegionSize.y < normalRegion[i + 1]) {
                normalRegionSize.y = normalRegion[i + 1];
            }
            i += 2;
        }
        Point normalRegionCenter = new Point(normalRegionSize.x / 2, normalRegionSize.y / 2);
        Point shellSize = this.shell.getSize();
        Point regionIncrement = new Point(shellSize.x - normalRegionSize.x, shellSize.y - normalRegionSize.y);
        int[] shellRegion = Arrays.copyOf(normalRegion, normalRegion.length);
        int i2 = 0;
        while (i2 < shellRegion.length) {
            if (shellRegion[i2] > normalRegionCenter.x) {
                int n = i2;
                shellRegion[n] = shellRegion[n] + regionIncrement.x;
            }
            if (shellRegion[i2 + 1] > normalRegionCenter.y) {
                int n = i2 + 1;
                shellRegion[n] = shellRegion[n] + regionIncrement.y;
            }
            i2 += 2;
        }
        final Region region = new Region();
        region.add(shellRegion);
        this.shell.setRegion(region);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                region.dispose();
            }
        });
    }

    @Override
    public void setOrientationAndLocationAndSize(int orientation, Point location, Point browserSize, ResizableSkinSizeAdvisor sizeAdvisor) {
        this.vertical = orientation == 0 || orientation == 180;
        String urlTextText = this.deviceComposite.getUrlText().getText();
        String pageTitle = this.deviceComposite.getPageTitleStyledText() != null ? this.deviceComposite.getPageTitleStyledText().getText() : "";
        boolean backEnabled = this.deviceComposite.getBackButtonComposite().getEnabled();
        boolean forwardEnabled = false;
        if (this.deviceComposite.getForwardButtonComposite() != null) {
            forwardEnabled = this.deviceComposite.getForwardButtonComposite().getEnabled();
        }
        boolean navBarVisible = this.deviceComposite.isNavBarCompositeVisible();
        Menu contextMenu = this.deviceComposite.getMenu();
        this.deviceComposite.setMenu(null);
        DeviceComposite oldDeviceComposite = this.deviceComposite;
        this.deviceComposite = this.createDeviceComposite((Composite)this.shell, this.vertical);
        this.bindDeviceCompositeControls();
        Composite browserContainer = this.deviceComposite.getBrowserContainer();
        browserContainer.setLayout((Layout)new FillLayout());
        this.innerBrowserContainer.setParent(browserContainer);
        oldDeviceComposite.dispose();
        Point bordersSize = this.getBordersSize(this.vertical);
        int shellWidthHint = browserSize.x == -1 ? -1 : bordersSize.x + browserSize.x;
        int shellHeightHint = browserSize.y == -1 ? -1 : bordersSize.y + browserSize.y;
        Point prefferedShellSize = this.shell.computeSize(shellWidthHint, shellHeightHint);
        Point shellSize = sizeAdvisor.checkWindowSize(orientation, browserSize, prefferedShellSize);
        this.shell.setSize(shellSize);
        BrowserSimUtil.setShellLocation(this.shell, shellSize, location);
        this.shell.layout(true);
        this.setShellRegion();
        this.deviceComposite.getUrlText().setText(urlTextText);
        if (this.deviceComposite.getPageTitleStyledText() != null) {
            this.deviceComposite.getPageTitleStyledText().setText(pageTitle);
        }
        this.deviceComposite.getBackButtonComposite().setEnabled(backEnabled);
        if (this.deviceComposite.getForwardButtonComposite() != null) {
            this.deviceComposite.getForwardButtonComposite().setEnabled(forwardEnabled);
        }
        this.deviceComposite.setNavBarCompositeVisible(navBarVisible);
        this.deviceComposite.setMenu(contextMenu);
    }

    @Override
    public void statusTextChanged(String newStatusText) {
    }

    @Override
    public void progressChanged(int percents) {
        ProgressBar progressBar = this.deviceComposite.getProgressBar();
        if (percents > 0) {
            progressBar.setVisible(true);
            progressBar.setSelection(percents);
        } else {
            progressBar.setVisible(false);
            progressBar.setSelection(0);
        }
    }

    @Override
    public void locationChanged(String newLocation, boolean backEnabled, boolean forwardEnabled) {
        this.deviceComposite.getUrlText().setText(newLocation);
        this.deviceComposite.getBackButtonComposite().setEnabled(backEnabled);
        if (this.deviceComposite.getForwardButtonComposite() != null) {
            this.deviceComposite.getForwardButtonComposite().setEnabled(forwardEnabled);
        }
    }

    @Override
    public void pageTitleChanged(String newTitle) {
        if (this.deviceComposite.getPageTitleStyledText() != null) {
            this.deviceComposite.getPageTitleStyledText().setText(newTitle);
        }
    }

    private Point getBordersSize(boolean vertical) {
        return vertical ? this.verticalBorderSize : this.horizontalBorderSize;
    }

    protected abstract DeviceComposite createDeviceComposite(Composite var1, boolean var2);

    private int[] getNormalRegion(boolean vertical) {
        return vertical ? this.visibleRegionVertical : this.visibleRegionHorizontal;
    }

    @Override
    public Point getMinimalScreenSize() {
        return this.maxScreenSize;
    }

    @Override
    public IBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public Menu getMenuBar() {
        return this.display.getMenuBar();
    }

    @Override
    public void setControlHandler(ControlHandler controlHandler) {
        this.controlHandler = controlHandler;
    }

    @Override
    public void setAddressBarVisible(boolean visible) {
        this.deviceComposite.setNavBarCompositeVisible(visible);
    }

    @Override
    public void setContextMenu(Menu contextMenu) {
        this.deviceComposite.setMenu(contextMenu);
    }

    @Override
    public void setBrowserFactory(IBrowserSimBrowserFactory browserFactory) {
        this.browserFactory = browserFactory;
    }
}

