/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui.skin;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.vpe.browsersim.ui.skin.ImageButtonComposite;

public abstract class DeviceComposite
extends Composite {
    protected Composite bodyComposite;

    public DeviceComposite(Composite parent, int style) {
        super(parent, style);
    }

    public abstract ImageButtonComposite getBackButtonComposite();

    public abstract ImageButtonComposite getForwardButtonComposite();

    public abstract Composite getBrowserContainer();

    public abstract void setNavBarCompositeVisible(boolean var1);

    public abstract boolean isNavBarCompositeVisible();

    public abstract ImageButtonComposite getStopButtonComposite();

    public abstract ImageButtonComposite getRefreshButtonComposite();

    public abstract Text getUrlText();

    public abstract ProgressBar getProgressBar();

    public abstract StyledText getPageTitleStyledText();

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        switch (eventType) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.bodyComposite.addListener(eventType, listener);
                Control[] controlArray = this.bodyComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.addListener(eventType, listener);
                    ++n2;
                }
                break;
            }
        }
    }

    public void removeListener(int eventType, Listener listener) {
        super.removeListener(eventType, listener);
        switch (eventType) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.bodyComposite.removeListener(eventType, listener);
                Control[] controlArray = this.bodyComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.removeListener(eventType, listener);
                    ++n2;
                }
                break;
            }
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.bodyComposite.setMenu(menu);
        Control[] controlArray = this.bodyComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setMenu(menu);
            ++n2;
        }
    }

    public boolean isDeviceBody(Control contol) {
        Composite composite;
        return contol instanceof Composite && (composite = (Composite)contol).getParent() == this.bodyComposite && composite.getBackgroundImage() != null;
    }

    public boolean isDeviceCorner(Point displayPoint) {
        Point bodyPoint = this.bodyComposite.toControl(displayPoint);
        Point bodySize = this.bodyComposite.getSize();
        int cornersSize = this.getCornersSize();
        Rectangle leftTopCorner = new Rectangle(0, 0, cornersSize, cornersSize);
        Rectangle rightTopCorner = new Rectangle(bodySize.x - cornersSize, 0, cornersSize, cornersSize);
        Rectangle leftBottomCorner = new Rectangle(0, bodySize.y - cornersSize, cornersSize, cornersSize);
        Rectangle rightBottomCorner = new Rectangle(bodySize.x - cornersSize, bodySize.y - cornersSize, cornersSize, cornersSize);
        return leftTopCorner.contains(bodyPoint) || rightTopCorner.contains(bodyPoint) || leftBottomCorner.contains(bodyPoint) || rightBottomCorner.contains(bodyPoint);
    }

    protected abstract int getCornersSize();

    public abstract ImageButtonComposite getHomeButtonComposite();
}

