/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui.menu;

import java.text.MessageFormat;
import java.util.Map;
import java.util.UUID;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.vpe.browsersim.BrowserSimArgs;
import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.WebKitBrowserFactory;
import org.jboss.tools.vpe.browsersim.model.Device;
import org.jboss.tools.vpe.browsersim.model.preferences.BrowserSimSpecificPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.CommonPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.ui.BrowserSim;
import org.jboss.tools.vpe.browsersim.ui.Messages;
import org.jboss.tools.vpe.browsersim.ui.debug.firebug.FireBugLiteLoader;
import org.jboss.tools.vpe.browsersim.ui.menu.ScreenshotMenuCreator;
import org.jboss.tools.vpe.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.vpe.browsersim.util.BrowserSimImageList;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;

public class ToolsMenuCreator {
    private static final String DEV_TOOLS_ICON = "icons/dev_tools.png";

    public static void addDebugItem(Menu menu, BrowserSimSkin skin, String weinreScriptUrl, String weinreClientUrl, boolean isJavaFx) {
        MenuItem debug = new MenuItem(menu, 64);
        debug.setText(Messages.BrowserSim_DEBUG);
        Menu subMenu = new Menu(debug);
        ToolsMenuCreator.addWeinreItem(subMenu, skin, weinreScriptUrl, weinreClientUrl, isJavaFx);
        if (isJavaFx) {
            ToolsMenuCreator.addDevToolsItem(subMenu, skin);
        } else {
            ToolsMenuCreator.addFireBugLiteItem(subMenu, skin);
        }
        debug.setMenu(subMenu);
    }

    private static void addFireBugLiteItem(Menu menu, final BrowserSimSkin skin) {
        MenuItem fireBugLite = new MenuItem(menu, 8);
        fireBugLite.setText(Messages.BrowserSim_FIREBUG_LITE);
        fireBugLite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FireBugLiteLoader.startFireBugOpening(skin.getBrowser());
            }
        });
    }

    private static void addWeinreItem(Menu menu, final BrowserSimSkin skin, final String weinreScriptUrl, final String weinreClientUrl, final boolean isJavaFx) {
        MenuItem weinre = new MenuItem(menu, 8);
        weinre.setText(Messages.BrowserSim_WEINRE);
        weinre.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String clientUrl = (String)skin.getBrowser().evaluate("if(window.WeinreServerURL && window.WeinreServerId) {return window.WeinreServerURL + 'client/'} else {return null}");
                String id = (String)skin.getBrowser().evaluate("if(window.WeinreServerURL && window.WeinreServerId) {return window.WeinreServerId} else {return null}");
                if (clientUrl == null || id == null) {
                    id = UUID.randomUUID().toString();
                    clientUrl = weinreClientUrl;
                    ToolsMenuCreator.injectUrl(skin.getBrowser(), weinreScriptUrl, id);
                }
                ToolsMenuCreator.createWeinreShell(skin, String.valueOf(clientUrl) + "#" + id, weinreScriptUrl, id, isJavaFx).open();
            }
        });
    }

    public static void addScreenshotMenuItem(Menu menu, BrowserSimSkin skin, CommonPreferences commonPreferences) {
        MenuItem screenshot = new MenuItem(menu, 64);
        screenshot.setText(Messages.Screenshots_Screenshot);
        Menu subMenu = ScreenshotMenuCreator.createScreenshotsMenu(menu, Display.getDefault(), skin.getShell(), commonPreferences);
        screenshot.setMenu(subMenu);
    }

    public static void addSyncronizedWindowItem(Menu menu, final BrowserSimSkin skin, final Map<String, Device> devices, final Boolean useSkins, final Boolean enableLiveReload, final int liveReloadPort, final boolean enableTouchEvents, final int orientationAngle, final String homeUrl, final boolean isJavaFx) {
        MenuItem syncWindow = new MenuItem(menu, 64);
        syncWindow.setText(Messages.BrowserSim_SYNCHRONIZED_WINDOW);
        Menu subMenu = new Menu(menu);
        syncWindow.setMenu(subMenu);
        for (Device device : devices.values()) {
            MenuItem deviceMenuItem = new MenuItem(subMenu, 16);
            deviceMenuItem.setText(device.getName());
            deviceMenuItem.setData((Object)device.getId());
            deviceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.widget;
                    if (menuItem.getSelection()) {
                        Device selected = (Device)devices.get(menuItem.getData());
                        BrowserSimSpecificPreferences sp = new BrowserSimSpecificPreferences(selected.getId(), useSkins, enableLiveReload, liveReloadPort, enableTouchEvents, orientationAngle, null, isJavaFx);
                        BrowserSim browserSim1 = new BrowserSim(homeUrl, BrowserSimUtil.getParentShell(skin));
                        browserSim1.open(sp, skin.getBrowser().getUrl());
                    }
                }
            });
        }
    }

    private static void addDevToolsItem(Menu menu, final BrowserSimSkin skin) {
        MenuItem devToolsMenuItem = new MenuItem(menu, 8);
        devToolsMenuItem.setText(Messages.BrowserSim_DEV_TOOLS);
        devToolsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = "http://localhost:" + BrowserSimArgs.debuggerPort + "/inspector.html?host=localhost:" + BrowserSimArgs.debuggerPort + "&page=dtdb";
                String message = MessageFormat.format(Messages.BrowserSim_DEV_TOOLS_MESSAGE, url);
                Shell parentShell = skin.getShell();
                BrowserSimImageList imageList = new BrowserSimImageList((Widget)parentShell);
                BrowserSimUtil.showDevToolsDialog(parentShell, message, url, imageList.getImage(ToolsMenuCreator.DEV_TOOLS_ICON));
            }
        });
    }

    public static void addLiveReloadItem(Menu menu, final SpecificPreferences specificPreferences) {
        MenuItem liveReloadMenuItem = new MenuItem(menu, 32);
        liveReloadMenuItem.setText(Messages.BrowserSim_ENABLE_LIVE_RELOAD);
        liveReloadMenuItem.setSelection(specificPreferences.isEnableLiveReload());
        liveReloadMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem = (MenuItem)e.widget;
                specificPreferences.setEnableLiveReload(menuItem.getSelection());
                specificPreferences.notifyObservers();
            }
        });
    }

    public static void addTouchEventsItem(Menu menu, final SpecificPreferences specificPreferences) {
        MenuItem liveReloadMenuItem = new MenuItem(menu, 32);
        liveReloadMenuItem.setText(Messages.ManageDevicesDialog_SIMULATE_TOUCH_EVENTS);
        liveReloadMenuItem.setSelection(specificPreferences.isEnableTouchEvents());
        liveReloadMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem = (MenuItem)e.widget;
                specificPreferences.setEnableTouchEvents(menuItem.getSelection());
                specificPreferences.notifyObservers();
            }
        });
    }

    private static void injectUrl(IBrowser browser, String scriptUrl, String ID) {
        browser.execute("var head = document.head;var script = document.createElement('script');head.appendChild(script);script.src='" + scriptUrl + "#" + ID + "'");
    }

    private static Shell createWeinreShell(final BrowserSimSkin skin, String clientUrl, final String scriptUrl, final String id, boolean isJavaFx) {
        Shell shell = new Shell(BrowserSimUtil.getParentShell(skin), 1264);
        shell.setLayout((Layout)new FillLayout(768));
        shell.setText(Messages.BrowserSim_WEINRE_INSPECTOR);
        Composite browserComposite = ToolsMenuCreator.createBrowserComposite(shell, clientUrl);
        final IBrowser weinreBrowser = ToolsMenuCreator.createWeinreBrowser(browserComposite, isJavaFx);
        weinreBrowser.setUrl(clientUrl);
        final LocationAdapter locationAdapter = new LocationAdapter(){

            public void changed(LocationEvent event) {
                if (event.top) {
                    IBrowser browser = (IBrowser)event.widget;
                    browser.execute("window.addEventListener('load', function() {var head = document.head;var script = document.createElement('script');head.appendChild(script);script.src='" + scriptUrl + "#" + id + "';" + "});");
                }
            }
        };
        skin.getBrowser().addLocationListener((LocationListener)locationAdapter);
        weinreBrowser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                skin.getBrowser().removeLocationListener((LocationListener)locationAdapter);
            }
        });
        skin.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (!weinreBrowser.isDisposed() && !weinreBrowser.getShell().isDisposed()) {
                    weinreBrowser.getShell().dispose();
                }
            }
        });
        return shell;
    }

    private static Composite createBrowserComposite(final Shell weinreShell, String clientUrl) {
        Menu menuBar = Display.getDefault().getMenuBar();
        if (menuBar == null) {
            menuBar = new Menu((Decorations)weinreShell, 2);
            weinreShell.setMenuBar(menuBar);
        }
        MenuItem help = new MenuItem(menuBar, 64);
        help.setText(Messages.BrowserSim_WEINRE_HELP);
        Menu subMenu = new Menu(menuBar);
        help.setMenu(subMenu);
        MenuItem about = new MenuItem(subMenu, 0);
        about.setText(Messages.BrowserSim_WEINRE_ABOUT);
        about.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserSimUtil.showAboutDialog(weinreShell, Messages.BrowserSim_ABOUT_WEINRE_MESSAGE, Display.getDefault().getSystemImage(2));
            }
        });
        Composite browserComposite = new Composite((Composite)weinreShell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        browserComposite.setLayout((Layout)gridLayout);
        Text locationText = new Text(browserComposite, 2056);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 0;
        locationText.setLayoutData((Object)data);
        locationText.setText(clientUrl);
        return browserComposite;
    }

    private static IBrowser createWeinreBrowser(Composite browserComposite, boolean isJavaFX) {
        IBrowser browser = new WebKitBrowserFactory().createBrowser(browserComposite, 65536, isJavaFX);
        GridData browserData = new GridData();
        browserData.horizontalAlignment = 4;
        browserData.verticalAlignment = 4;
        browserData.horizontalSpan = 1;
        browserData.grabExcessHorizontalSpace = true;
        browserData.grabExcessVerticalSpace = true;
        browser.setLayoutData((Object)browserData);
        final ProgressBar progressBar = new ProgressBar(browserComposite, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        progressBar.setLayoutData((Object)data);
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.current == event.total || event.total == 0) {
                    progressBar.setSelection(0);
                    progressBar.setEnabled(false);
                } else {
                    int ratio = event.current * 100 / event.total;
                    progressBar.setEnabled(true);
                    progressBar.setSelection(ratio);
                }
            }

            public void completed(ProgressEvent event) {
                progressBar.setSelection(0);
                progressBar.setEnabled(false);
            }
        });
        return browser;
    }
}

