/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui.menu;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.vpe.browsersim.BrowserSimArgs;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;
import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.model.preferences.CommonPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.ui.BrowserSimSourceViewer;
import org.jboss.tools.vpe.browsersim.ui.ExceptionNotifier;
import org.jboss.tools.vpe.browsersim.ui.ManageDevicesDialog;
import org.jboss.tools.vpe.browsersim.ui.Messages;
import org.jboss.tools.vpe.browsersim.ui.PreferencesWrapper;
import org.jboss.tools.vpe.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;
import org.jboss.tools.vpe.browsersim.util.PreferencesUtil;

public class FileMenuCreator {
    protected static final String OPEN_FILE_COMMAND = "org.jboss.tools.vpe.browsersim.command.openFile:";
    private static final String VIEW_SOURCE_COMMAND = "org.jboss.tools.vpe.browsersim.command.viewSource:";

    public void addItemsToMenuBar(Menu menu, BrowserSimSkin skin, CommonPreferences commonPreferences, SpecificPreferences specificPreferences) {
        this.addOpenInDefaultBrowserItem(menu, skin);
        this.addViewSourceItem(menu, skin);
        if (!"macosx".equals(PlatformUtil.getOs())) {
            this.addPreferencesItem(menu, commonPreferences, specificPreferences, skin.getBrowser().getUrl());
        }
    }

    public void addItemsToContextMenu(Menu menu, BrowserSimSkin skin, CommonPreferences commonPreferences, SpecificPreferences specificPreferences) {
        this.addOpenInDefaultBrowserItem(menu, skin);
        this.addViewSourceItem(menu, skin);
        this.addPreferencesItem(menu, commonPreferences, specificPreferences, skin.getBrowser().getUrl());
    }

    private void addOpenInDefaultBrowserItem(Menu menu, final BrowserSimSkin skin) {
        MenuItem openInDefaultBrowser = new MenuItem(menu, 8);
        openInDefaultBrowser.setText(Messages.BrowserSim_OPEN_IN_DEFAULT_BROWSER);
        openInDefaultBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    URL url = new URL(skin.getBrowser().getUrl());
                    Program.launch((String)url.toString());
                }
                catch (MalformedURLException e) {
                    BrowserSimLogger.logError(e.getMessage(), e);
                    ExceptionNotifier.showErrorMessage(skin.getShell(), String.valueOf(Messages.BrowserSim_COULD_NOT_OPEN_DEFAULT_BROWSER) + e.getMessage());
                }
            }
        });
    }

    private void addViewSourceItem(Menu menu, final BrowserSimSkin skin) {
        MenuItem openInDefaultBrowser = new MenuItem(menu, 8);
        openInDefaultBrowser.setText(Messages.BrowserSim_VIEW_PAGE_SOURCE);
        openInDefaultBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (BrowserSimArgs.standalone) {
                    FileMenuCreator.this.viewSource(skin);
                } else if (skin.getBrowser().getUrl().startsWith("file:")) {
                    FileMenuCreator.this.openFile(skin.getBrowser().getUrl());
                } else {
                    FileMenuCreator.this.viewServerSource(skin.getBrowser());
                }
            }
        });
    }

    private void viewSource(BrowserSimSkin skin) {
        final BrowserSimSourceViewer sourceViewer = new BrowserSimSourceViewer(BrowserSimUtil.getParentShell(skin));
        sourceViewer.setText(skin.getBrowser().getText());
        sourceViewer.open();
        skin.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                Shell sourceShell = sourceViewer.getShell();
                if (!sourceShell.isDisposed()) {
                    sourceShell.dispose();
                }
            }
        });
    }

    protected void openFile(String path) {
        URI uri = null;
        try {
            uri = new URI(path);
            File sourceFile = new File(uri);
            System.out.println(OPEN_FILE_COMMAND + sourceFile.getAbsolutePath());
        }
        catch (URISyntaxException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
    }

    protected void viewServerSource(IBrowser browser) {
        if (!"about:blank".equals(browser.getUrl())) {
            String source = browser.getText();
            try {
                File configFolder = new File(PreferencesUtil.getConfigFolderPath());
                configFolder.mkdir();
                File temp = new File(configFolder, "temp.html");
                FileWriter fw = new FileWriter(temp.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(source);
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                BrowserSimLogger.logError("Cannot create temp file", e);
            }
            System.out.println(VIEW_SOURCE_COMMAND + browser.getUrl());
        }
    }

    private void addPreferencesItem(Menu menu, final CommonPreferences commonPreferences, final SpecificPreferences specificPreferences, final String currentUrl) {
        MenuItem preferences = new MenuItem(menu, 8);
        preferences.setText(Messages.BrowserSim_PREFERENCES);
        preferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesWrapper pw;
                Shell parentShell = Display.getDefault().getActiveShell();
                if (parentShell == null) {
                    parentShell = Display.getDefault().getShells()[0];
                }
                if ((pw = FileMenuCreator.this.openDialog(parentShell, commonPreferences, specificPreferences, currentUrl)) != null) {
                    commonPreferences.copyProperties(pw.getCommonPreferences());
                    specificPreferences.copyProperties(pw.getSpecificPreferences());
                    commonPreferences.notifyObservers();
                    specificPreferences.notifyObservers();
                }
            }
        });
    }

    protected PreferencesWrapper openDialog(Shell parentShell, CommonPreferences commonPreferences, SpecificPreferences specificPreferences, String currentUrl) {
        return new ManageDevicesDialog(parentShell, 66800, commonPreferences, specificPreferences, currentUrl).open();
    }
}

