/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui.debug.firebug;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.vpe.browsersim.browser.ExtendedCloseWindowListener;
import org.jboss.tools.vpe.browsersim.browser.ExtendedVisibilityWindowListener;
import org.jboss.tools.vpe.browsersim.browser.ExtendedWindowEvent;
import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.browser.WebKitBrowserFactory;
import org.jboss.tools.vpe.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;

public class FireBugLiteLoader {
    private static final String FIREBUG_LITE_JS_URL = "https://getfirebug.com/firebug-lite.js";

    public static void startFireBugOpening(IBrowser browser) {
        browser.execute("window._fireBugLiteLoading = true;");
        Object fireBugScriptLoaded = browser.evaluate("return !!window.Firebug");
        if (!Boolean.TRUE.equals(fireBugScriptLoaded)) {
            browser.execute("(function() {var initializeFireBug = function() {var cordovaOpen = window.open;window.open = window._bsOriginalWindowOpen || window.open;window.Firebug.chrome.toggle(true, true);window.open = cordovaOpen;};var e = document.createElement('script');e.type = 'text/javascript';e.src = 'https://getfirebug.com/firebug-lite.js';e.addEventListener('load',function() {setTimeout(function() {setTimeout(initializeFireBug, 0)}, 0)}, false);document.head.appendChild(e);})()");
        } else {
            browser.execute("var cordovaOpen = window.open;window.open = window._bsOriginalWindowOpen || window.open;window.Firebug.chrome.close();window.Firebug.chrome.toggle(true, true);window.open = cordovaOpen;");
        }
    }

    public static boolean isFireBugPopUp(ExtendedWindowEvent openWindowEvent) {
        IBrowser parentBrowser = (IBrowser)openWindowEvent.widget;
        return Boolean.TRUE.equals(parentBrowser.evaluate("return !!window._fireBugLiteLoading"));
    }

    public static void processFireBugPopUp(ExtendedWindowEvent openWindowEvent, BrowserSimSkin skin, boolean isJavaFx) {
        IBrowser fireBugBrowser;
        final IBrowser parentBrowser = (IBrowser)openWindowEvent.widget;
        parentBrowser.execute("window._fireBugLiteLoading = false;");
        Shell shell = new Shell(BrowserSimUtil.getParentShell(skin), 1264);
        shell.setLayout((Layout)new FillLayout());
        openWindowEvent.browser = fireBugBrowser = new WebKitBrowserFactory().createBrowser((Composite)shell, 65536, isJavaFx);
        fireBugBrowser.addVisibilityWindowListener(new ExtendedVisibilityWindowListener(){

            public void show(ExtendedWindowEvent event) {
                IBrowser fblBrowser = (IBrowser)event.widget;
                Shell shell = fblBrowser.getShell();
                Point location = event.location;
                if (location != null && Display.getDefault().getClientArea().intersects(new Rectangle(location.x, location.y, event.size.x, event.size.y))) {
                    shell.setLocation(location);
                }
                shell.open();
            }

            public void hide(ExtendedWindowEvent event) {
                IBrowser browser = (IBrowser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }
        });
        skin.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!fireBugBrowser.isDisposed() && !fireBugBrowser.getShell().isDisposed()) {
                            fireBugBrowser.getShell().dispose();
                        }
                    }
                });
            }
        });
        if ("macosx".equals(PlatformUtil.getOs())) {
            shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    if (!parentBrowser.isDisposed()) {
                        parentBrowser.execute("window.Firebug.chrome.close();");
                    }
                }
            });
        }
        fireBugBrowser.addCloseWindowListener(new ExtendedCloseWindowListener(){

            public void close(ExtendedWindowEvent event) {
                IBrowser browser = (IBrowser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
    }
}

