/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CocoaUIEnhancer {
    private static final int kAboutMenuItem = 0;
    private static final int kPreferencesMenuItem = 2;
    private static final int kQuitMenuItem = 10;
    static long sel_toolbarButtonClicked_;
    static long sel_preferencesMenuItemSelected_;
    static long sel_aboutMenuItemSelected_;
    static Callback proc3Args;
    private Runnable quitAction;
    private Runnable aboutAction;
    private Runnable preferencesAction;
    private static CocoaUIEnhancer instance;

    public static void initializeMacOSMenuBar(String appName) {
        if (instance != null) {
            throw new IllegalStateException("Mac OS menu bar is already initialized");
        }
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
        instance = new CocoaUIEnhancer();
        instance.hookApplicationMenu(Display.getDefault());
    }

    public static CocoaUIEnhancer getInstance() {
        return instance;
    }

    private void hookApplicationMenu(Display display) {
        Object target = new Object(){

            int actionProc(int id, int sel, int arg0) {
                return (int)this.actionProc((long)id, (long)sel, (long)arg0);
            }

            long actionProc(long id, long sel, long arg0) {
                if (sel == sel_aboutMenuItemSelected_) {
                    if (CocoaUIEnhancer.this.aboutAction != null) {
                        CocoaUIEnhancer.this.aboutAction.run();
                    }
                } else if (sel == sel_preferencesMenuItemSelected_ && CocoaUIEnhancer.this.preferencesAction != null) {
                    CocoaUIEnhancer.this.preferencesAction.run();
                }
                return 99L;
            }
        };
        try {
            this.initialize(target);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (!display.isDisposed()) {
            display.addListener(21, new Listener(){

                public void handleEvent(Event arg0) {
                    if (CocoaUIEnhancer.this.quitAction != null) {
                        CocoaUIEnhancer.this.quitAction.run();
                    }
                }
            });
        }
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                CocoaUIEnhancer.this.invoke(proc3Args, "dispose");
            }
        });
    }

    private void initialize(Object callbackObject) throws Exception {
        Class<?> osCls = this.classForName("org.eclipse.swt.internal.cocoa.OS");
        if (sel_toolbarButtonClicked_ == 0L) {
            sel_preferencesMenuItemSelected_ = this.registerName(osCls, "preferencesMenuItemSelected:");
            sel_aboutMenuItemSelected_ = this.registerName(osCls, "aboutMenuItemSelected:");
        }
        proc3Args = new Callback(callbackObject, "actionProc", 3);
        Method getAddress = Callback.class.getMethod("getAddress", new Class[0]);
        Object object = getAddress.invoke((Object)proc3Args, null);
        long proc3 = this.convertToLong(object);
        if (proc3 == 0L) {
            SWT.error((int)3);
        }
        Class<?> nsmenuCls = this.classForName("org.eclipse.swt.internal.cocoa.NSMenu");
        Class<?> nsmenuitemCls = this.classForName("org.eclipse.swt.internal.cocoa.NSMenuItem");
        this.classForName("org.eclipse.swt.internal.cocoa.NSString");
        Class<?> nsapplicationCls = this.classForName("org.eclipse.swt.internal.cocoa.NSApplication");
        object = CocoaUIEnhancer.invoke(osCls, "objc_lookUpClass", new Object[]{"SWTApplicationDelegate"});
        long cls = this.convertToLong(object);
        CocoaUIEnhancer.invoke(osCls, "class_addMethod", new Object[]{CocoaUIEnhancer.wrapPointer(cls), CocoaUIEnhancer.wrapPointer(sel_preferencesMenuItemSelected_), CocoaUIEnhancer.wrapPointer(proc3), "@:@"});
        CocoaUIEnhancer.invoke(osCls, "class_addMethod", new Object[]{CocoaUIEnhancer.wrapPointer(cls), CocoaUIEnhancer.wrapPointer(sel_aboutMenuItemSelected_), CocoaUIEnhancer.wrapPointer(proc3), "@:@"});
        Object sharedApplication = this.invoke(nsapplicationCls, "sharedApplication");
        Object mainMenu = this.invoke(sharedApplication, "mainMenu");
        Object mainMenuItem = CocoaUIEnhancer.invoke(nsmenuCls, mainMenu, "itemAtIndex", new Object[]{CocoaUIEnhancer.wrapPointer(0L)});
        Object appMenu = this.invoke(mainMenuItem, "submenu");
        Object aboutMenuItem = CocoaUIEnhancer.invoke(nsmenuCls, appMenu, "itemAtIndex", new Object[]{CocoaUIEnhancer.wrapPointer(0L)});
        Object prefMenuItem = CocoaUIEnhancer.invoke(nsmenuCls, appMenu, "itemAtIndex", new Object[]{CocoaUIEnhancer.wrapPointer(2L)});
        CocoaUIEnhancer.invoke(nsmenuitemCls, prefMenuItem, "setEnabled", new Object[]{true});
        CocoaUIEnhancer.invoke(nsmenuitemCls, prefMenuItem, "setAction", new Object[]{CocoaUIEnhancer.wrapPointer(sel_preferencesMenuItemSelected_)});
        CocoaUIEnhancer.invoke(nsmenuitemCls, aboutMenuItem, "setAction", new Object[]{CocoaUIEnhancer.wrapPointer(sel_aboutMenuItemSelected_)});
    }

    private long registerName(Class<?> osCls, String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = CocoaUIEnhancer.invoke(osCls, "sel_registerName", new Object[]{name});
        return this.convertToLong(object);
    }

    private long convertToLong(Object object) {
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i.longValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        return 0L;
    }

    private static Object wrapPointer(long value) {
        Class<Number> PTR_CLASS;
        Class<Number> clazz = PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        if (PTR_CLASS == Long.TYPE) {
            return new Long(value);
        }
        return new Integer((int)value);
    }

    private static Object invoke(Class<?> clazz, String methodName, Object[] args) {
        return CocoaUIEnhancer.invoke(clazz, null, methodName, args);
    }

    private static Object invoke(Class<?> clazz, Object target, String methodName, Object[] args) {
        try {
            Class[] signature = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                Class<?> thisClass = args[i].getClass();
                signature[i] = thisClass == Integer.class ? Integer.TYPE : (thisClass == Long.class ? Long.TYPE : (thisClass == Byte.class ? Byte.TYPE : (thisClass == Boolean.class ? Boolean.TYPE : thisClass)));
                ++i;
            }
            Method method = clazz.getMethod(methodName, signature);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Class<?> classForName(String classname) {
        try {
            Class<?> cls = Class.forName(classname);
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object invoke(Class<?> cls, String methodName) {
        return this.invoke(cls, methodName, null, null);
    }

    private Object invoke(Class<?> cls, String methodName, Class<?>[] paramTypes, Object ... arguments) {
        try {
            Method m = cls.getDeclaredMethod(methodName, paramTypes);
            return m.invoke(null, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Object invoke(Object obj, String methodName) {
        return this.invoke(obj, methodName, null, null);
    }

    private Object invoke(Object obj, String methodName, Class<?>[] paramTypes, Object ... arguments) {
        try {
            Method m = obj.getClass().getDeclaredMethod(methodName, paramTypes);
            return m.invoke(obj, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setQuitAction(Runnable quitAction) {
        this.quitAction = quitAction;
    }

    public void setAboutAction(Runnable aboutAction) {
        this.aboutAction = aboutAction;
    }

    public void setPreferencesAction(Runnable preferencesAction) {
        this.preferencesAction = preferencesAction;
    }
}

